/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.EksContainerEnvironmentVariable;
import com.amazonaws.services.batch.model.EksContainerResourceRequirements;
import com.amazonaws.services.batch.model.transform.EksContainerOverrideMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EksContainerOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private String image;
    private List<String> command;
    private List<String> args;
    private List<EksContainerEnvironmentVariable> env;
    private EksContainerResourceRequirements resources;

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public EksContainerOverride withImage(String image) {
        this.setImage(image);
        return this;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        this.command = new ArrayList<String>(command);
    }

    public EksContainerOverride withCommand(String ... command) {
        if (this.command == null) {
            this.setCommand(new ArrayList<String>(command.length));
        }
        for (String ele : command) {
            this.command.add(ele);
        }
        return this;
    }

    public EksContainerOverride withCommand(Collection<String> command) {
        this.setCommand(command);
        return this;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
            return;
        }
        this.args = new ArrayList<String>(args);
    }

    public EksContainerOverride withArgs(String ... args) {
        if (this.args == null) {
            this.setArgs(new ArrayList<String>(args.length));
        }
        for (String ele : args) {
            this.args.add(ele);
        }
        return this;
    }

    public EksContainerOverride withArgs(Collection<String> args) {
        this.setArgs(args);
        return this;
    }

    public List<EksContainerEnvironmentVariable> getEnv() {
        return this.env;
    }

    public void setEnv(Collection<EksContainerEnvironmentVariable> env) {
        if (env == null) {
            this.env = null;
            return;
        }
        this.env = new ArrayList<EksContainerEnvironmentVariable>(env);
    }

    public EksContainerOverride withEnv(EksContainerEnvironmentVariable ... env) {
        if (this.env == null) {
            this.setEnv(new ArrayList<EksContainerEnvironmentVariable>(env.length));
        }
        for (EksContainerEnvironmentVariable ele : env) {
            this.env.add(ele);
        }
        return this;
    }

    public EksContainerOverride withEnv(Collection<EksContainerEnvironmentVariable> env) {
        this.setEnv(env);
        return this;
    }

    public void setResources(EksContainerResourceRequirements resources) {
        this.resources = resources;
    }

    public EksContainerResourceRequirements getResources() {
        return this.resources;
    }

    public EksContainerOverride withResources(EksContainerResourceRequirements resources) {
        this.setResources(resources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand()).append(",");
        }
        if (this.getArgs() != null) {
            sb.append("Args: ").append(this.getArgs()).append(",");
        }
        if (this.getEnv() != null) {
            sb.append("Env: ").append(this.getEnv()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksContainerOverride)) {
            return false;
        }
        EksContainerOverride other = (EksContainerOverride)obj;
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getArgs() == null ^ this.getArgs() == null) {
            return false;
        }
        if (other.getArgs() != null && !other.getArgs().equals(this.getArgs())) {
            return false;
        }
        if (other.getEnv() == null ^ this.getEnv() == null) {
            return false;
        }
        if (other.getEnv() != null && !other.getEnv().equals(this.getEnv())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        return other.getResources() == null || other.getResources().equals(this.getResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getArgs() == null ? 0 : this.getArgs().hashCode());
        hashCode = 31 * hashCode + (this.getEnv() == null ? 0 : this.getEnv().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        return hashCode;
    }

    public EksContainerOverride clone() {
        try {
            return (EksContainerOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EksContainerOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

