/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.UpdateComputeEnvironmentRequest;
import com.amazonaws.services.batch.model.transform.ComputeResourceUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateComputeEnvironmentRequestMarshaller
implements Marshaller<Request<UpdateComputeEnvironmentRequest>, UpdateComputeEnvironmentRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateComputeEnvironmentRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateComputeEnvironmentRequest> marshall(UpdateComputeEnvironmentRequest updateComputeEnvironmentRequest) {
        if (updateComputeEnvironmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateComputeEnvironmentRequest, "AWSBatch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/updatecomputeenvironment";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateComputeEnvironmentRequest.getComputeEnvironment() != null) {
                jsonGenerator.writeFieldName("computeEnvironment").writeValue(updateComputeEnvironmentRequest.getComputeEnvironment());
            }
            if (updateComputeEnvironmentRequest.getState() != null) {
                jsonGenerator.writeFieldName("state").writeValue(updateComputeEnvironmentRequest.getState());
            }
            if (updateComputeEnvironmentRequest.getComputeResources() != null) {
                jsonGenerator.writeFieldName("computeResources");
                ComputeResourceUpdateJsonMarshaller.getInstance().marshall(updateComputeEnvironmentRequest.getComputeResources(), jsonGenerator);
            }
            if (updateComputeEnvironmentRequest.getServiceRole() != null) {
                jsonGenerator.writeFieldName("serviceRole").writeValue(updateComputeEnvironmentRequest.getServiceRole());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

