/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.BackupJobState;
import com.amazonaws.services.backup.model.RecoveryPointCreator;
import com.amazonaws.services.backup.model.transform.BackupJobMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BackupJob
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private String backupJobId;
    private String backupVaultName;
    private String backupVaultArn;
    private String recoveryPointArn;
    private String resourceArn;
    private Date creationDate;
    private Date completionDate;
    private String state;
    private String statusMessage;
    private String percentDone;
    private Long backupSizeInBytes;
    private String iamRoleArn;
    private RecoveryPointCreator createdBy;
    private Date expectedCompletionDate;
    private Date startBy;
    private String resourceType;
    private Long bytesTransferred;
    private Map<String, String> backupOptions;
    private String backupType;
    private String parentJobId;
    private Boolean isParent;
    private String resourceName;
    private String messageCategory;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public BackupJob withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setBackupJobId(String backupJobId) {
        this.backupJobId = backupJobId;
    }

    public String getBackupJobId() {
        return this.backupJobId;
    }

    public BackupJob withBackupJobId(String backupJobId) {
        this.setBackupJobId(backupJobId);
        return this;
    }

    public void setBackupVaultName(String backupVaultName) {
        this.backupVaultName = backupVaultName;
    }

    public String getBackupVaultName() {
        return this.backupVaultName;
    }

    public BackupJob withBackupVaultName(String backupVaultName) {
        this.setBackupVaultName(backupVaultName);
        return this;
    }

    public void setBackupVaultArn(String backupVaultArn) {
        this.backupVaultArn = backupVaultArn;
    }

    public String getBackupVaultArn() {
        return this.backupVaultArn;
    }

    public BackupJob withBackupVaultArn(String backupVaultArn) {
        this.setBackupVaultArn(backupVaultArn);
        return this;
    }

    public void setRecoveryPointArn(String recoveryPointArn) {
        this.recoveryPointArn = recoveryPointArn;
    }

    public String getRecoveryPointArn() {
        return this.recoveryPointArn;
    }

    public BackupJob withRecoveryPointArn(String recoveryPointArn) {
        this.setRecoveryPointArn(recoveryPointArn);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public BackupJob withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public BackupJob withCreationDate(Date creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public BackupJob withCompletionDate(Date completionDate) {
        this.setCompletionDate(completionDate);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public BackupJob withState(String state) {
        this.setState(state);
        return this;
    }

    public BackupJob withState(BackupJobState state) {
        this.state = state.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public BackupJob withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public void setPercentDone(String percentDone) {
        this.percentDone = percentDone;
    }

    public String getPercentDone() {
        return this.percentDone;
    }

    public BackupJob withPercentDone(String percentDone) {
        this.setPercentDone(percentDone);
        return this;
    }

    public void setBackupSizeInBytes(Long backupSizeInBytes) {
        this.backupSizeInBytes = backupSizeInBytes;
    }

    public Long getBackupSizeInBytes() {
        return this.backupSizeInBytes;
    }

    public BackupJob withBackupSizeInBytes(Long backupSizeInBytes) {
        this.setBackupSizeInBytes(backupSizeInBytes);
        return this;
    }

    public void setIamRoleArn(String iamRoleArn) {
        this.iamRoleArn = iamRoleArn;
    }

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    public BackupJob withIamRoleArn(String iamRoleArn) {
        this.setIamRoleArn(iamRoleArn);
        return this;
    }

    public void setCreatedBy(RecoveryPointCreator createdBy) {
        this.createdBy = createdBy;
    }

    public RecoveryPointCreator getCreatedBy() {
        return this.createdBy;
    }

    public BackupJob withCreatedBy(RecoveryPointCreator createdBy) {
        this.setCreatedBy(createdBy);
        return this;
    }

    public void setExpectedCompletionDate(Date expectedCompletionDate) {
        this.expectedCompletionDate = expectedCompletionDate;
    }

    public Date getExpectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    public BackupJob withExpectedCompletionDate(Date expectedCompletionDate) {
        this.setExpectedCompletionDate(expectedCompletionDate);
        return this;
    }

    public void setStartBy(Date startBy) {
        this.startBy = startBy;
    }

    public Date getStartBy() {
        return this.startBy;
    }

    public BackupJob withStartBy(Date startBy) {
        this.setStartBy(startBy);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public BackupJob withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setBytesTransferred(Long bytesTransferred) {
        this.bytesTransferred = bytesTransferred;
    }

    public Long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public BackupJob withBytesTransferred(Long bytesTransferred) {
        this.setBytesTransferred(bytesTransferred);
        return this;
    }

    public Map<String, String> getBackupOptions() {
        return this.backupOptions;
    }

    public void setBackupOptions(Map<String, String> backupOptions) {
        this.backupOptions = backupOptions;
    }

    public BackupJob withBackupOptions(Map<String, String> backupOptions) {
        this.setBackupOptions(backupOptions);
        return this;
    }

    public BackupJob addBackupOptionsEntry(String key, String value) {
        if (null == this.backupOptions) {
            this.backupOptions = new HashMap<String, String>();
        }
        if (this.backupOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.backupOptions.put(key, value);
        return this;
    }

    public BackupJob clearBackupOptionsEntries() {
        this.backupOptions = null;
        return this;
    }

    public void setBackupType(String backupType) {
        this.backupType = backupType;
    }

    public String getBackupType() {
        return this.backupType;
    }

    public BackupJob withBackupType(String backupType) {
        this.setBackupType(backupType);
        return this;
    }

    public void setParentJobId(String parentJobId) {
        this.parentJobId = parentJobId;
    }

    public String getParentJobId() {
        return this.parentJobId;
    }

    public BackupJob withParentJobId(String parentJobId) {
        this.setParentJobId(parentJobId);
        return this;
    }

    public void setIsParent(Boolean isParent) {
        this.isParent = isParent;
    }

    public Boolean getIsParent() {
        return this.isParent;
    }

    public BackupJob withIsParent(Boolean isParent) {
        this.setIsParent(isParent);
        return this;
    }

    public Boolean isParent() {
        return this.isParent;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public BackupJob withResourceName(String resourceName) {
        this.setResourceName(resourceName);
        return this;
    }

    public void setMessageCategory(String messageCategory) {
        this.messageCategory = messageCategory;
    }

    public String getMessageCategory() {
        return this.messageCategory;
    }

    public BackupJob withMessageCategory(String messageCategory) {
        this.setMessageCategory(messageCategory);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getBackupJobId() != null) {
            sb.append("BackupJobId: ").append(this.getBackupJobId()).append(",");
        }
        if (this.getBackupVaultName() != null) {
            sb.append("BackupVaultName: ").append(this.getBackupVaultName()).append(",");
        }
        if (this.getBackupVaultArn() != null) {
            sb.append("BackupVaultArn: ").append(this.getBackupVaultArn()).append(",");
        }
        if (this.getRecoveryPointArn() != null) {
            sb.append("RecoveryPointArn: ").append(this.getRecoveryPointArn()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: ").append(this.getCreationDate()).append(",");
        }
        if (this.getCompletionDate() != null) {
            sb.append("CompletionDate: ").append(this.getCompletionDate()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getPercentDone() != null) {
            sb.append("PercentDone: ").append(this.getPercentDone()).append(",");
        }
        if (this.getBackupSizeInBytes() != null) {
            sb.append("BackupSizeInBytes: ").append(this.getBackupSizeInBytes()).append(",");
        }
        if (this.getIamRoleArn() != null) {
            sb.append("IamRoleArn: ").append(this.getIamRoleArn()).append(",");
        }
        if (this.getCreatedBy() != null) {
            sb.append("CreatedBy: ").append(this.getCreatedBy()).append(",");
        }
        if (this.getExpectedCompletionDate() != null) {
            sb.append("ExpectedCompletionDate: ").append(this.getExpectedCompletionDate()).append(",");
        }
        if (this.getStartBy() != null) {
            sb.append("StartBy: ").append(this.getStartBy()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getBytesTransferred() != null) {
            sb.append("BytesTransferred: ").append(this.getBytesTransferred()).append(",");
        }
        if (this.getBackupOptions() != null) {
            sb.append("BackupOptions: ").append(this.getBackupOptions()).append(",");
        }
        if (this.getBackupType() != null) {
            sb.append("BackupType: ").append(this.getBackupType()).append(",");
        }
        if (this.getParentJobId() != null) {
            sb.append("ParentJobId: ").append(this.getParentJobId()).append(",");
        }
        if (this.getIsParent() != null) {
            sb.append("IsParent: ").append(this.getIsParent()).append(",");
        }
        if (this.getResourceName() != null) {
            sb.append("ResourceName: ").append(this.getResourceName()).append(",");
        }
        if (this.getMessageCategory() != null) {
            sb.append("MessageCategory: ").append(this.getMessageCategory());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupJob)) {
            return false;
        }
        BackupJob other = (BackupJob)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getBackupJobId() == null ^ this.getBackupJobId() == null) {
            return false;
        }
        if (other.getBackupJobId() != null && !other.getBackupJobId().equals(this.getBackupJobId())) {
            return false;
        }
        if (other.getBackupVaultName() == null ^ this.getBackupVaultName() == null) {
            return false;
        }
        if (other.getBackupVaultName() != null && !other.getBackupVaultName().equals(this.getBackupVaultName())) {
            return false;
        }
        if (other.getBackupVaultArn() == null ^ this.getBackupVaultArn() == null) {
            return false;
        }
        if (other.getBackupVaultArn() != null && !other.getBackupVaultArn().equals(this.getBackupVaultArn())) {
            return false;
        }
        if (other.getRecoveryPointArn() == null ^ this.getRecoveryPointArn() == null) {
            return false;
        }
        if (other.getRecoveryPointArn() != null && !other.getRecoveryPointArn().equals(this.getRecoveryPointArn())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getCompletionDate() == null ^ this.getCompletionDate() == null) {
            return false;
        }
        if (other.getCompletionDate() != null && !other.getCompletionDate().equals(this.getCompletionDate())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getPercentDone() == null ^ this.getPercentDone() == null) {
            return false;
        }
        if (other.getPercentDone() != null && !other.getPercentDone().equals(this.getPercentDone())) {
            return false;
        }
        if (other.getBackupSizeInBytes() == null ^ this.getBackupSizeInBytes() == null) {
            return false;
        }
        if (other.getBackupSizeInBytes() != null && !other.getBackupSizeInBytes().equals(this.getBackupSizeInBytes())) {
            return false;
        }
        if (other.getIamRoleArn() == null ^ this.getIamRoleArn() == null) {
            return false;
        }
        if (other.getIamRoleArn() != null && !other.getIamRoleArn().equals(this.getIamRoleArn())) {
            return false;
        }
        if (other.getCreatedBy() == null ^ this.getCreatedBy() == null) {
            return false;
        }
        if (other.getCreatedBy() != null && !other.getCreatedBy().equals(this.getCreatedBy())) {
            return false;
        }
        if (other.getExpectedCompletionDate() == null ^ this.getExpectedCompletionDate() == null) {
            return false;
        }
        if (other.getExpectedCompletionDate() != null && !other.getExpectedCompletionDate().equals(this.getExpectedCompletionDate())) {
            return false;
        }
        if (other.getStartBy() == null ^ this.getStartBy() == null) {
            return false;
        }
        if (other.getStartBy() != null && !other.getStartBy().equals(this.getStartBy())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getBytesTransferred() == null ^ this.getBytesTransferred() == null) {
            return false;
        }
        if (other.getBytesTransferred() != null && !other.getBytesTransferred().equals(this.getBytesTransferred())) {
            return false;
        }
        if (other.getBackupOptions() == null ^ this.getBackupOptions() == null) {
            return false;
        }
        if (other.getBackupOptions() != null && !other.getBackupOptions().equals(this.getBackupOptions())) {
            return false;
        }
        if (other.getBackupType() == null ^ this.getBackupType() == null) {
            return false;
        }
        if (other.getBackupType() != null && !other.getBackupType().equals(this.getBackupType())) {
            return false;
        }
        if (other.getParentJobId() == null ^ this.getParentJobId() == null) {
            return false;
        }
        if (other.getParentJobId() != null && !other.getParentJobId().equals(this.getParentJobId())) {
            return false;
        }
        if (other.getIsParent() == null ^ this.getIsParent() == null) {
            return false;
        }
        if (other.getIsParent() != null && !other.getIsParent().equals(this.getIsParent())) {
            return false;
        }
        if (other.getResourceName() == null ^ this.getResourceName() == null) {
            return false;
        }
        if (other.getResourceName() != null && !other.getResourceName().equals(this.getResourceName())) {
            return false;
        }
        if (other.getMessageCategory() == null ^ this.getMessageCategory() == null) {
            return false;
        }
        return other.getMessageCategory() == null || other.getMessageCategory().equals(this.getMessageCategory());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getBackupJobId() == null ? 0 : this.getBackupJobId().hashCode());
        hashCode = 31 * hashCode + (this.getBackupVaultName() == null ? 0 : this.getBackupVaultName().hashCode());
        hashCode = 31 * hashCode + (this.getBackupVaultArn() == null ? 0 : this.getBackupVaultArn().hashCode());
        hashCode = 31 * hashCode + (this.getRecoveryPointArn() == null ? 0 : this.getRecoveryPointArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getCompletionDate() == null ? 0 : this.getCompletionDate().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getPercentDone() == null ? 0 : this.getPercentDone().hashCode());
        hashCode = 31 * hashCode + (this.getBackupSizeInBytes() == null ? 0 : this.getBackupSizeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.getIamRoleArn() == null ? 0 : this.getIamRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        hashCode = 31 * hashCode + (this.getExpectedCompletionDate() == null ? 0 : this.getExpectedCompletionDate().hashCode());
        hashCode = 31 * hashCode + (this.getStartBy() == null ? 0 : this.getStartBy().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getBytesTransferred() == null ? 0 : this.getBytesTransferred().hashCode());
        hashCode = 31 * hashCode + (this.getBackupOptions() == null ? 0 : this.getBackupOptions().hashCode());
        hashCode = 31 * hashCode + (this.getBackupType() == null ? 0 : this.getBackupType().hashCode());
        hashCode = 31 * hashCode + (this.getParentJobId() == null ? 0 : this.getParentJobId().hashCode());
        hashCode = 31 * hashCode + (this.getIsParent() == null ? 0 : this.getIsParent().hashCode());
        hashCode = 31 * hashCode + (this.getResourceName() == null ? 0 : this.getResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getMessageCategory() == null ? 0 : this.getMessageCategory().hashCode());
        return hashCode;
    }

    public BackupJob clone() {
        try {
            return (BackupJob)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

