/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.Lifecycle;
import com.amazonaws.services.backup.model.transform.BackupRuleInputMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BackupRuleInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String ruleName;
    private String targetBackupVaultName;
    private String scheduleExpression;
    private Long startWindowMinutes;
    private Long completionWindowMinutes;
    private Lifecycle lifecycle;
    private Map<String, String> recoveryPointTags;

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public BackupRuleInput withRuleName(String ruleName) {
        this.setRuleName(ruleName);
        return this;
    }

    public void setTargetBackupVaultName(String targetBackupVaultName) {
        this.targetBackupVaultName = targetBackupVaultName;
    }

    public String getTargetBackupVaultName() {
        return this.targetBackupVaultName;
    }

    public BackupRuleInput withTargetBackupVaultName(String targetBackupVaultName) {
        this.setTargetBackupVaultName(targetBackupVaultName);
        return this;
    }

    public void setScheduleExpression(String scheduleExpression) {
        this.scheduleExpression = scheduleExpression;
    }

    public String getScheduleExpression() {
        return this.scheduleExpression;
    }

    public BackupRuleInput withScheduleExpression(String scheduleExpression) {
        this.setScheduleExpression(scheduleExpression);
        return this;
    }

    public void setStartWindowMinutes(Long startWindowMinutes) {
        this.startWindowMinutes = startWindowMinutes;
    }

    public Long getStartWindowMinutes() {
        return this.startWindowMinutes;
    }

    public BackupRuleInput withStartWindowMinutes(Long startWindowMinutes) {
        this.setStartWindowMinutes(startWindowMinutes);
        return this;
    }

    public void setCompletionWindowMinutes(Long completionWindowMinutes) {
        this.completionWindowMinutes = completionWindowMinutes;
    }

    public Long getCompletionWindowMinutes() {
        return this.completionWindowMinutes;
    }

    public BackupRuleInput withCompletionWindowMinutes(Long completionWindowMinutes) {
        this.setCompletionWindowMinutes(completionWindowMinutes);
        return this;
    }

    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public BackupRuleInput withLifecycle(Lifecycle lifecycle) {
        this.setLifecycle(lifecycle);
        return this;
    }

    public Map<String, String> getRecoveryPointTags() {
        return this.recoveryPointTags;
    }

    public void setRecoveryPointTags(Map<String, String> recoveryPointTags) {
        this.recoveryPointTags = recoveryPointTags;
    }

    public BackupRuleInput withRecoveryPointTags(Map<String, String> recoveryPointTags) {
        this.setRecoveryPointTags(recoveryPointTags);
        return this;
    }

    public BackupRuleInput addRecoveryPointTagsEntry(String key, String value) {
        if (null == this.recoveryPointTags) {
            this.recoveryPointTags = new HashMap<String, String>();
        }
        if (this.recoveryPointTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.recoveryPointTags.put(key, value);
        return this;
    }

    public BackupRuleInput clearRecoveryPointTagsEntries() {
        this.recoveryPointTags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleName() != null) {
            sb.append("RuleName: ").append(this.getRuleName()).append(",");
        }
        if (this.getTargetBackupVaultName() != null) {
            sb.append("TargetBackupVaultName: ").append(this.getTargetBackupVaultName()).append(",");
        }
        if (this.getScheduleExpression() != null) {
            sb.append("ScheduleExpression: ").append(this.getScheduleExpression()).append(",");
        }
        if (this.getStartWindowMinutes() != null) {
            sb.append("StartWindowMinutes: ").append(this.getStartWindowMinutes()).append(",");
        }
        if (this.getCompletionWindowMinutes() != null) {
            sb.append("CompletionWindowMinutes: ").append(this.getCompletionWindowMinutes()).append(",");
        }
        if (this.getLifecycle() != null) {
            sb.append("Lifecycle: ").append(this.getLifecycle()).append(",");
        }
        if (this.getRecoveryPointTags() != null) {
            sb.append("RecoveryPointTags: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupRuleInput)) {
            return false;
        }
        BackupRuleInput other = (BackupRuleInput)obj;
        if (other.getRuleName() == null ^ this.getRuleName() == null) {
            return false;
        }
        if (other.getRuleName() != null && !other.getRuleName().equals(this.getRuleName())) {
            return false;
        }
        if (other.getTargetBackupVaultName() == null ^ this.getTargetBackupVaultName() == null) {
            return false;
        }
        if (other.getTargetBackupVaultName() != null && !other.getTargetBackupVaultName().equals(this.getTargetBackupVaultName())) {
            return false;
        }
        if (other.getScheduleExpression() == null ^ this.getScheduleExpression() == null) {
            return false;
        }
        if (other.getScheduleExpression() != null && !other.getScheduleExpression().equals(this.getScheduleExpression())) {
            return false;
        }
        if (other.getStartWindowMinutes() == null ^ this.getStartWindowMinutes() == null) {
            return false;
        }
        if (other.getStartWindowMinutes() != null && !other.getStartWindowMinutes().equals(this.getStartWindowMinutes())) {
            return false;
        }
        if (other.getCompletionWindowMinutes() == null ^ this.getCompletionWindowMinutes() == null) {
            return false;
        }
        if (other.getCompletionWindowMinutes() != null && !other.getCompletionWindowMinutes().equals(this.getCompletionWindowMinutes())) {
            return false;
        }
        if (other.getLifecycle() == null ^ this.getLifecycle() == null) {
            return false;
        }
        if (other.getLifecycle() != null && !other.getLifecycle().equals(this.getLifecycle())) {
            return false;
        }
        if (other.getRecoveryPointTags() == null ^ this.getRecoveryPointTags() == null) {
            return false;
        }
        return other.getRecoveryPointTags() == null || other.getRecoveryPointTags().equals(this.getRecoveryPointTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleName() == null ? 0 : this.getRuleName().hashCode());
        hashCode = 31 * hashCode + (this.getTargetBackupVaultName() == null ? 0 : this.getTargetBackupVaultName().hashCode());
        hashCode = 31 * hashCode + (this.getScheduleExpression() == null ? 0 : this.getScheduleExpression().hashCode());
        hashCode = 31 * hashCode + (this.getStartWindowMinutes() == null ? 0 : this.getStartWindowMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getCompletionWindowMinutes() == null ? 0 : this.getCompletionWindowMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycle() == null ? 0 : this.getLifecycle().hashCode());
        hashCode = 31 * hashCode + (this.getRecoveryPointTags() == null ? 0 : this.getRecoveryPointTags().hashCode());
        return hashCode;
    }

    public BackupRuleInput clone() {
        try {
            return (BackupRuleInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupRuleInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

