/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.b2bi.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.b2bi.model.EdiType;

@SdkInternalApi
public class EdiTypeMarshaller {
    private static final MarshallingInfo<StructuredPojo> X12DETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("x12Details").build();
    private static final EdiTypeMarshaller instance = new EdiTypeMarshaller();

    public static EdiTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(EdiType ediType, ProtocolMarshaller protocolMarshaller) {
        if (ediType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ediType.getX12Details(), X12DETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

