/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.b2bi;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.b2bi.AWSB2BiAsync;
import com.amazonaws.services.b2bi.AWSB2BiAsyncClientBuilder;
import com.amazonaws.services.b2bi.AWSB2BiClient;
import com.amazonaws.services.b2bi.model.CreateCapabilityRequest;
import com.amazonaws.services.b2bi.model.CreateCapabilityResult;
import com.amazonaws.services.b2bi.model.CreatePartnershipRequest;
import com.amazonaws.services.b2bi.model.CreatePartnershipResult;
import com.amazonaws.services.b2bi.model.CreateProfileRequest;
import com.amazonaws.services.b2bi.model.CreateProfileResult;
import com.amazonaws.services.b2bi.model.CreateTransformerRequest;
import com.amazonaws.services.b2bi.model.CreateTransformerResult;
import com.amazonaws.services.b2bi.model.DeleteCapabilityRequest;
import com.amazonaws.services.b2bi.model.DeleteCapabilityResult;
import com.amazonaws.services.b2bi.model.DeletePartnershipRequest;
import com.amazonaws.services.b2bi.model.DeletePartnershipResult;
import com.amazonaws.services.b2bi.model.DeleteProfileRequest;
import com.amazonaws.services.b2bi.model.DeleteProfileResult;
import com.amazonaws.services.b2bi.model.DeleteTransformerRequest;
import com.amazonaws.services.b2bi.model.DeleteTransformerResult;
import com.amazonaws.services.b2bi.model.GetCapabilityRequest;
import com.amazonaws.services.b2bi.model.GetCapabilityResult;
import com.amazonaws.services.b2bi.model.GetPartnershipRequest;
import com.amazonaws.services.b2bi.model.GetPartnershipResult;
import com.amazonaws.services.b2bi.model.GetProfileRequest;
import com.amazonaws.services.b2bi.model.GetProfileResult;
import com.amazonaws.services.b2bi.model.GetTransformerJobRequest;
import com.amazonaws.services.b2bi.model.GetTransformerJobResult;
import com.amazonaws.services.b2bi.model.GetTransformerRequest;
import com.amazonaws.services.b2bi.model.GetTransformerResult;
import com.amazonaws.services.b2bi.model.ListCapabilitiesRequest;
import com.amazonaws.services.b2bi.model.ListCapabilitiesResult;
import com.amazonaws.services.b2bi.model.ListPartnershipsRequest;
import com.amazonaws.services.b2bi.model.ListPartnershipsResult;
import com.amazonaws.services.b2bi.model.ListProfilesRequest;
import com.amazonaws.services.b2bi.model.ListProfilesResult;
import com.amazonaws.services.b2bi.model.ListTagsForResourceRequest;
import com.amazonaws.services.b2bi.model.ListTagsForResourceResult;
import com.amazonaws.services.b2bi.model.ListTransformersRequest;
import com.amazonaws.services.b2bi.model.ListTransformersResult;
import com.amazonaws.services.b2bi.model.StartTransformerJobRequest;
import com.amazonaws.services.b2bi.model.StartTransformerJobResult;
import com.amazonaws.services.b2bi.model.TagResourceRequest;
import com.amazonaws.services.b2bi.model.TagResourceResult;
import com.amazonaws.services.b2bi.model.TestMappingRequest;
import com.amazonaws.services.b2bi.model.TestMappingResult;
import com.amazonaws.services.b2bi.model.TestParsingRequest;
import com.amazonaws.services.b2bi.model.TestParsingResult;
import com.amazonaws.services.b2bi.model.UntagResourceRequest;
import com.amazonaws.services.b2bi.model.UntagResourceResult;
import com.amazonaws.services.b2bi.model.UpdateCapabilityRequest;
import com.amazonaws.services.b2bi.model.UpdateCapabilityResult;
import com.amazonaws.services.b2bi.model.UpdatePartnershipRequest;
import com.amazonaws.services.b2bi.model.UpdatePartnershipResult;
import com.amazonaws.services.b2bi.model.UpdateProfileRequest;
import com.amazonaws.services.b2bi.model.UpdateProfileResult;
import com.amazonaws.services.b2bi.model.UpdateTransformerRequest;
import com.amazonaws.services.b2bi.model.UpdateTransformerResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSB2BiAsyncClient
extends AWSB2BiClient
implements AWSB2BiAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSB2BiAsyncClientBuilder asyncBuilder() {
        return AWSB2BiAsyncClientBuilder.standard();
    }

    AWSB2BiAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSB2BiAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateCapabilityResult> createCapabilityAsync(CreateCapabilityRequest request) {
        return this.createCapabilityAsync(request, null);
    }

    @Override
    public Future<CreateCapabilityResult> createCapabilityAsync(CreateCapabilityRequest request, final AsyncHandler<CreateCapabilityRequest, CreateCapabilityResult> asyncHandler) {
        final CreateCapabilityRequest finalRequest = (CreateCapabilityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCapabilityResult>(){

            @Override
            public CreateCapabilityResult call() throws Exception {
                CreateCapabilityResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeCreateCapability(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePartnershipResult> createPartnershipAsync(CreatePartnershipRequest request) {
        return this.createPartnershipAsync(request, null);
    }

    @Override
    public Future<CreatePartnershipResult> createPartnershipAsync(CreatePartnershipRequest request, final AsyncHandler<CreatePartnershipRequest, CreatePartnershipResult> asyncHandler) {
        final CreatePartnershipRequest finalRequest = (CreatePartnershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePartnershipResult>(){

            @Override
            public CreatePartnershipResult call() throws Exception {
                CreatePartnershipResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeCreatePartnership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProfileResult> createProfileAsync(CreateProfileRequest request) {
        return this.createProfileAsync(request, null);
    }

    @Override
    public Future<CreateProfileResult> createProfileAsync(CreateProfileRequest request, final AsyncHandler<CreateProfileRequest, CreateProfileResult> asyncHandler) {
        final CreateProfileRequest finalRequest = (CreateProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateProfileResult>(){

            @Override
            public CreateProfileResult call() throws Exception {
                CreateProfileResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeCreateProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTransformerResult> createTransformerAsync(CreateTransformerRequest request) {
        return this.createTransformerAsync(request, null);
    }

    @Override
    public Future<CreateTransformerResult> createTransformerAsync(CreateTransformerRequest request, final AsyncHandler<CreateTransformerRequest, CreateTransformerResult> asyncHandler) {
        final CreateTransformerRequest finalRequest = (CreateTransformerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTransformerResult>(){

            @Override
            public CreateTransformerResult call() throws Exception {
                CreateTransformerResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeCreateTransformer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCapabilityResult> deleteCapabilityAsync(DeleteCapabilityRequest request) {
        return this.deleteCapabilityAsync(request, null);
    }

    @Override
    public Future<DeleteCapabilityResult> deleteCapabilityAsync(DeleteCapabilityRequest request, final AsyncHandler<DeleteCapabilityRequest, DeleteCapabilityResult> asyncHandler) {
        final DeleteCapabilityRequest finalRequest = (DeleteCapabilityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCapabilityResult>(){

            @Override
            public DeleteCapabilityResult call() throws Exception {
                DeleteCapabilityResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeDeleteCapability(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePartnershipResult> deletePartnershipAsync(DeletePartnershipRequest request) {
        return this.deletePartnershipAsync(request, null);
    }

    @Override
    public Future<DeletePartnershipResult> deletePartnershipAsync(DeletePartnershipRequest request, final AsyncHandler<DeletePartnershipRequest, DeletePartnershipResult> asyncHandler) {
        final DeletePartnershipRequest finalRequest = (DeletePartnershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePartnershipResult>(){

            @Override
            public DeletePartnershipResult call() throws Exception {
                DeletePartnershipResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeDeletePartnership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProfileResult> deleteProfileAsync(DeleteProfileRequest request) {
        return this.deleteProfileAsync(request, null);
    }

    @Override
    public Future<DeleteProfileResult> deleteProfileAsync(DeleteProfileRequest request, final AsyncHandler<DeleteProfileRequest, DeleteProfileResult> asyncHandler) {
        final DeleteProfileRequest finalRequest = (DeleteProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteProfileResult>(){

            @Override
            public DeleteProfileResult call() throws Exception {
                DeleteProfileResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeDeleteProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTransformerResult> deleteTransformerAsync(DeleteTransformerRequest request) {
        return this.deleteTransformerAsync(request, null);
    }

    @Override
    public Future<DeleteTransformerResult> deleteTransformerAsync(DeleteTransformerRequest request, final AsyncHandler<DeleteTransformerRequest, DeleteTransformerResult> asyncHandler) {
        final DeleteTransformerRequest finalRequest = (DeleteTransformerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTransformerResult>(){

            @Override
            public DeleteTransformerResult call() throws Exception {
                DeleteTransformerResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeDeleteTransformer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCapabilityResult> getCapabilityAsync(GetCapabilityRequest request) {
        return this.getCapabilityAsync(request, null);
    }

    @Override
    public Future<GetCapabilityResult> getCapabilityAsync(GetCapabilityRequest request, final AsyncHandler<GetCapabilityRequest, GetCapabilityResult> asyncHandler) {
        final GetCapabilityRequest finalRequest = (GetCapabilityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCapabilityResult>(){

            @Override
            public GetCapabilityResult call() throws Exception {
                GetCapabilityResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeGetCapability(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPartnershipResult> getPartnershipAsync(GetPartnershipRequest request) {
        return this.getPartnershipAsync(request, null);
    }

    @Override
    public Future<GetPartnershipResult> getPartnershipAsync(GetPartnershipRequest request, final AsyncHandler<GetPartnershipRequest, GetPartnershipResult> asyncHandler) {
        final GetPartnershipRequest finalRequest = (GetPartnershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPartnershipResult>(){

            @Override
            public GetPartnershipResult call() throws Exception {
                GetPartnershipResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeGetPartnership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProfileResult> getProfileAsync(GetProfileRequest request) {
        return this.getProfileAsync(request, null);
    }

    @Override
    public Future<GetProfileResult> getProfileAsync(GetProfileRequest request, final AsyncHandler<GetProfileRequest, GetProfileResult> asyncHandler) {
        final GetProfileRequest finalRequest = (GetProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProfileResult>(){

            @Override
            public GetProfileResult call() throws Exception {
                GetProfileResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeGetProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTransformerResult> getTransformerAsync(GetTransformerRequest request) {
        return this.getTransformerAsync(request, null);
    }

    @Override
    public Future<GetTransformerResult> getTransformerAsync(GetTransformerRequest request, final AsyncHandler<GetTransformerRequest, GetTransformerResult> asyncHandler) {
        final GetTransformerRequest finalRequest = (GetTransformerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTransformerResult>(){

            @Override
            public GetTransformerResult call() throws Exception {
                GetTransformerResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeGetTransformer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTransformerJobResult> getTransformerJobAsync(GetTransformerJobRequest request) {
        return this.getTransformerJobAsync(request, null);
    }

    @Override
    public Future<GetTransformerJobResult> getTransformerJobAsync(GetTransformerJobRequest request, final AsyncHandler<GetTransformerJobRequest, GetTransformerJobResult> asyncHandler) {
        final GetTransformerJobRequest finalRequest = (GetTransformerJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTransformerJobResult>(){

            @Override
            public GetTransformerJobResult call() throws Exception {
                GetTransformerJobResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeGetTransformerJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCapabilitiesResult> listCapabilitiesAsync(ListCapabilitiesRequest request) {
        return this.listCapabilitiesAsync(request, null);
    }

    @Override
    public Future<ListCapabilitiesResult> listCapabilitiesAsync(ListCapabilitiesRequest request, final AsyncHandler<ListCapabilitiesRequest, ListCapabilitiesResult> asyncHandler) {
        final ListCapabilitiesRequest finalRequest = (ListCapabilitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCapabilitiesResult>(){

            @Override
            public ListCapabilitiesResult call() throws Exception {
                ListCapabilitiesResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeListCapabilities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPartnershipsResult> listPartnershipsAsync(ListPartnershipsRequest request) {
        return this.listPartnershipsAsync(request, null);
    }

    @Override
    public Future<ListPartnershipsResult> listPartnershipsAsync(ListPartnershipsRequest request, final AsyncHandler<ListPartnershipsRequest, ListPartnershipsResult> asyncHandler) {
        final ListPartnershipsRequest finalRequest = (ListPartnershipsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPartnershipsResult>(){

            @Override
            public ListPartnershipsResult call() throws Exception {
                ListPartnershipsResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeListPartnerships(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProfilesResult> listProfilesAsync(ListProfilesRequest request) {
        return this.listProfilesAsync(request, null);
    }

    @Override
    public Future<ListProfilesResult> listProfilesAsync(ListProfilesRequest request, final AsyncHandler<ListProfilesRequest, ListProfilesResult> asyncHandler) {
        final ListProfilesRequest finalRequest = (ListProfilesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProfilesResult>(){

            @Override
            public ListProfilesResult call() throws Exception {
                ListProfilesResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeListProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTransformersResult> listTransformersAsync(ListTransformersRequest request) {
        return this.listTransformersAsync(request, null);
    }

    @Override
    public Future<ListTransformersResult> listTransformersAsync(ListTransformersRequest request, final AsyncHandler<ListTransformersRequest, ListTransformersResult> asyncHandler) {
        final ListTransformersRequest finalRequest = (ListTransformersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTransformersResult>(){

            @Override
            public ListTransformersResult call() throws Exception {
                ListTransformersResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeListTransformers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartTransformerJobResult> startTransformerJobAsync(StartTransformerJobRequest request) {
        return this.startTransformerJobAsync(request, null);
    }

    @Override
    public Future<StartTransformerJobResult> startTransformerJobAsync(StartTransformerJobRequest request, final AsyncHandler<StartTransformerJobRequest, StartTransformerJobResult> asyncHandler) {
        final StartTransformerJobRequest finalRequest = (StartTransformerJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartTransformerJobResult>(){

            @Override
            public StartTransformerJobResult call() throws Exception {
                StartTransformerJobResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeStartTransformerJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestMappingResult> testMappingAsync(TestMappingRequest request) {
        return this.testMappingAsync(request, null);
    }

    @Override
    public Future<TestMappingResult> testMappingAsync(TestMappingRequest request, final AsyncHandler<TestMappingRequest, TestMappingResult> asyncHandler) {
        final TestMappingRequest finalRequest = (TestMappingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TestMappingResult>(){

            @Override
            public TestMappingResult call() throws Exception {
                TestMappingResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeTestMapping(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestParsingResult> testParsingAsync(TestParsingRequest request) {
        return this.testParsingAsync(request, null);
    }

    @Override
    public Future<TestParsingResult> testParsingAsync(TestParsingRequest request, final AsyncHandler<TestParsingRequest, TestParsingResult> asyncHandler) {
        final TestParsingRequest finalRequest = (TestParsingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TestParsingResult>(){

            @Override
            public TestParsingResult call() throws Exception {
                TestParsingResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeTestParsing(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCapabilityResult> updateCapabilityAsync(UpdateCapabilityRequest request) {
        return this.updateCapabilityAsync(request, null);
    }

    @Override
    public Future<UpdateCapabilityResult> updateCapabilityAsync(UpdateCapabilityRequest request, final AsyncHandler<UpdateCapabilityRequest, UpdateCapabilityResult> asyncHandler) {
        final UpdateCapabilityRequest finalRequest = (UpdateCapabilityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCapabilityResult>(){

            @Override
            public UpdateCapabilityResult call() throws Exception {
                UpdateCapabilityResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeUpdateCapability(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePartnershipResult> updatePartnershipAsync(UpdatePartnershipRequest request) {
        return this.updatePartnershipAsync(request, null);
    }

    @Override
    public Future<UpdatePartnershipResult> updatePartnershipAsync(UpdatePartnershipRequest request, final AsyncHandler<UpdatePartnershipRequest, UpdatePartnershipResult> asyncHandler) {
        final UpdatePartnershipRequest finalRequest = (UpdatePartnershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePartnershipResult>(){

            @Override
            public UpdatePartnershipResult call() throws Exception {
                UpdatePartnershipResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeUpdatePartnership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProfileResult> updateProfileAsync(UpdateProfileRequest request) {
        return this.updateProfileAsync(request, null);
    }

    @Override
    public Future<UpdateProfileResult> updateProfileAsync(UpdateProfileRequest request, final AsyncHandler<UpdateProfileRequest, UpdateProfileResult> asyncHandler) {
        final UpdateProfileRequest finalRequest = (UpdateProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateProfileResult>(){

            @Override
            public UpdateProfileResult call() throws Exception {
                UpdateProfileResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeUpdateProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTransformerResult> updateTransformerAsync(UpdateTransformerRequest request) {
        return this.updateTransformerAsync(request, null);
    }

    @Override
    public Future<UpdateTransformerResult> updateTransformerAsync(UpdateTransformerRequest request, final AsyncHandler<UpdateTransformerRequest, UpdateTransformerResult> asyncHandler) {
        final UpdateTransformerRequest finalRequest = (UpdateTransformerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTransformerResult>(){

            @Override
            public UpdateTransformerResult call() throws Exception {
                UpdateTransformerResult result = null;
                try {
                    result = AWSB2BiAsyncClient.this.executeUpdateTransformer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

