/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.InstancesDistribution;
import com.amazonaws.services.autoscaling.model.LaunchTemplate;
import com.amazonaws.services.autoscaling.model.LaunchTemplateOverrides;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.autoscaling.model.MixedInstancesPolicy;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<UpdateAutoScalingGroupRequest>, UpdateAutoScalingGroupRequest> {
    public Request<UpdateAutoScalingGroupRequest> marshall(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) {
        MixedInstancesPolicy mixedInstancesPolicy;
        LaunchTemplateSpecification launchTemplate;
        if (updateAutoScalingGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateAutoScalingGroupRequest, "AmazonAutoScaling");
        request.addParameter("Action", "UpdateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateAutoScalingGroupRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)updateAutoScalingGroupRequest.getAutoScalingGroupName()));
        }
        if (updateAutoScalingGroupRequest.getLaunchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString((String)updateAutoScalingGroupRequest.getLaunchConfigurationName()));
        }
        if ((launchTemplate = updateAutoScalingGroupRequest.getLaunchTemplate()) != null) {
            if (launchTemplate.getLaunchTemplateId() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateId", StringUtils.fromString((String)launchTemplate.getLaunchTemplateId()));
            }
            if (launchTemplate.getLaunchTemplateName() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateName", StringUtils.fromString((String)launchTemplate.getLaunchTemplateName()));
            }
            if (launchTemplate.getVersion() != null) {
                request.addParameter("LaunchTemplate.Version", StringUtils.fromString((String)launchTemplate.getVersion()));
            }
        }
        if ((mixedInstancesPolicy = updateAutoScalingGroupRequest.getMixedInstancesPolicy()) != null) {
            InstancesDistribution instancesDistribution;
            LaunchTemplate launchTemplate2 = mixedInstancesPolicy.getLaunchTemplate();
            if (launchTemplate2 != null) {
                LaunchTemplateSpecification launchTemplateSpecification = launchTemplate2.getLaunchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateId()));
                    }
                    if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateName()));
                    }
                    if (launchTemplateSpecification.getVersion() != null) {
                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification.getVersion()));
                    }
                }
                if (!launchTemplate2.getOverrides().isEmpty() || !((SdkInternalList)launchTemplate2.getOverrides()).isAutoConstruct()) {
                    SdkInternalList overridesList = (SdkInternalList)launchTemplate2.getOverrides();
                    int overridesListIndex = 1;
                    for (LaunchTemplateOverrides overridesListValue : overridesList) {
                        if (overridesListValue.getInstanceType() != null) {
                            request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceType", StringUtils.fromString((String)overridesListValue.getInstanceType()));
                        }
                        if (overridesListValue.getWeightedCapacity() != null) {
                            request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".WeightedCapacity", StringUtils.fromString((String)overridesListValue.getWeightedCapacity()));
                        }
                        ++overridesListIndex;
                    }
                }
            }
            if ((instancesDistribution = mixedInstancesPolicy.getInstancesDistribution()) != null) {
                if (instancesDistribution.getOnDemandAllocationStrategy() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.OnDemandAllocationStrategy", StringUtils.fromString((String)instancesDistribution.getOnDemandAllocationStrategy()));
                }
                if (instancesDistribution.getOnDemandBaseCapacity() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.OnDemandBaseCapacity", StringUtils.fromInteger((Integer)instancesDistribution.getOnDemandBaseCapacity()));
                }
                if (instancesDistribution.getOnDemandPercentageAboveBaseCapacity() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.OnDemandPercentageAboveBaseCapacity", StringUtils.fromInteger((Integer)instancesDistribution.getOnDemandPercentageAboveBaseCapacity()));
                }
                if (instancesDistribution.getSpotAllocationStrategy() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.SpotAllocationStrategy", StringUtils.fromString((String)instancesDistribution.getSpotAllocationStrategy()));
                }
                if (instancesDistribution.getSpotInstancePools() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.SpotInstancePools", StringUtils.fromInteger((Integer)instancesDistribution.getSpotInstancePools()));
                }
                if (instancesDistribution.getSpotMaxPrice() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.SpotMaxPrice", StringUtils.fromString((String)instancesDistribution.getSpotMaxPrice()));
                }
            }
        }
        if (updateAutoScalingGroupRequest.getMinSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getMinSize()));
        }
        if (updateAutoScalingGroupRequest.getMaxSize() != null) {
            request.addParameter("MaxSize", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getMaxSize()));
        }
        if (updateAutoScalingGroupRequest.getDesiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getDesiredCapacity()));
        }
        if (updateAutoScalingGroupRequest.getDefaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getDefaultCooldown()));
        }
        if (!updateAutoScalingGroupRequest.getAvailabilityZones().isEmpty() || !((SdkInternalList)updateAutoScalingGroupRequest.getAvailabilityZones()).isAutoConstruct()) {
            SdkInternalList availabilityZonesList = (SdkInternalList)updateAutoScalingGroupRequest.getAvailabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (updateAutoScalingGroupRequest.getHealthCheckType() != null) {
            request.addParameter("HealthCheckType", StringUtils.fromString((String)updateAutoScalingGroupRequest.getHealthCheckType()));
        }
        if (updateAutoScalingGroupRequest.getHealthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getHealthCheckGracePeriod()));
        }
        if (updateAutoScalingGroupRequest.getPlacementGroup() != null) {
            request.addParameter("PlacementGroup", StringUtils.fromString((String)updateAutoScalingGroupRequest.getPlacementGroup()));
        }
        if (updateAutoScalingGroupRequest.getVPCZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier", StringUtils.fromString((String)updateAutoScalingGroupRequest.getVPCZoneIdentifier()));
        }
        if (!updateAutoScalingGroupRequest.getTerminationPolicies().isEmpty() || !((SdkInternalList)updateAutoScalingGroupRequest.getTerminationPolicies()).isAutoConstruct()) {
            SdkInternalList terminationPoliciesList = (SdkInternalList)updateAutoScalingGroupRequest.getTerminationPolicies();
            int terminationPoliciesListIndex = 1;
            for (String terminationPoliciesListValue : terminationPoliciesList) {
                if (terminationPoliciesListValue != null) {
                    request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex, StringUtils.fromString((String)terminationPoliciesListValue));
                }
                ++terminationPoliciesListIndex;
            }
        }
        if (updateAutoScalingGroupRequest.getNewInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn", StringUtils.fromBoolean((Boolean)updateAutoScalingGroupRequest.getNewInstancesProtectedFromScaleIn()));
        }
        if (updateAutoScalingGroupRequest.getServiceLinkedRoleARN() != null) {
            request.addParameter("ServiceLinkedRoleARN", StringUtils.fromString((String)updateAutoScalingGroupRequest.getServiceLinkedRoleARN()));
        }
        if (updateAutoScalingGroupRequest.getMaxInstanceLifetime() != null) {
            request.addParameter("MaxInstanceLifetime", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getMaxInstanceLifetime()));
        }
        return request;
    }
}

