/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.EnabledMetric;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.autoscaling.model.SuspendedProcess;
import com.amazonaws.services.autoscaling.model.TagDescription;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AutoScalingGroup
implements Serializable,
Cloneable {
    private String autoScalingGroupName;
    private String autoScalingGroupARN;
    private String launchConfigurationName;
    private LaunchTemplateSpecification launchTemplate;
    private Integer minSize;
    private Integer maxSize;
    private Integer desiredCapacity;
    private Integer defaultCooldown;
    private SdkInternalList<String> availabilityZones;
    private SdkInternalList<String> loadBalancerNames;
    private SdkInternalList<String> targetGroupARNs;
    private String healthCheckType;
    private Integer healthCheckGracePeriod;
    private SdkInternalList<Instance> instances;
    private Date createdTime;
    private SdkInternalList<SuspendedProcess> suspendedProcesses;
    private String placementGroup;
    private String vPCZoneIdentifier;
    private SdkInternalList<EnabledMetric> enabledMetrics;
    private String status;
    private SdkInternalList<TagDescription> tags;
    private SdkInternalList<String> terminationPolicies;
    private Boolean newInstancesProtectedFromScaleIn;

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public AutoScalingGroup withAutoScalingGroupName(String autoScalingGroupName) {
        this.setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    public void setAutoScalingGroupARN(String autoScalingGroupARN) {
        this.autoScalingGroupARN = autoScalingGroupARN;
    }

    public String getAutoScalingGroupARN() {
        return this.autoScalingGroupARN;
    }

    public AutoScalingGroup withAutoScalingGroupARN(String autoScalingGroupARN) {
        this.setAutoScalingGroupARN(autoScalingGroupARN);
        return this;
    }

    public void setLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public AutoScalingGroup withLaunchConfigurationName(String launchConfigurationName) {
        this.setLaunchConfigurationName(launchConfigurationName);
        return this;
    }

    public void setLaunchTemplate(LaunchTemplateSpecification launchTemplate) {
        this.launchTemplate = launchTemplate;
    }

    public LaunchTemplateSpecification getLaunchTemplate() {
        return this.launchTemplate;
    }

    public AutoScalingGroup withLaunchTemplate(LaunchTemplateSpecification launchTemplate) {
        this.setLaunchTemplate(launchTemplate);
        return this;
    }

    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public AutoScalingGroup withMinSize(Integer minSize) {
        this.setMinSize(minSize);
        return this;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public AutoScalingGroup withMaxSize(Integer maxSize) {
        this.setMaxSize(maxSize);
        return this;
    }

    public void setDesiredCapacity(Integer desiredCapacity) {
        this.desiredCapacity = desiredCapacity;
    }

    public Integer getDesiredCapacity() {
        return this.desiredCapacity;
    }

    public AutoScalingGroup withDesiredCapacity(Integer desiredCapacity) {
        this.setDesiredCapacity(desiredCapacity);
        return this;
    }

    public void setDefaultCooldown(Integer defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
    }

    public Integer getDefaultCooldown() {
        return this.defaultCooldown;
    }

    public AutoScalingGroup withDefaultCooldown(Integer defaultCooldown) {
        this.setDefaultCooldown(defaultCooldown);
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList(availabilityZones);
    }

    public AutoScalingGroup withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones((Collection<String>)new SdkInternalList(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add((Object)ele);
        }
        return this;
    }

    public AutoScalingGroup withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public List<String> getLoadBalancerNames() {
        if (this.loadBalancerNames == null) {
            this.loadBalancerNames = new SdkInternalList();
        }
        return this.loadBalancerNames;
    }

    public void setLoadBalancerNames(Collection<String> loadBalancerNames) {
        if (loadBalancerNames == null) {
            this.loadBalancerNames = null;
            return;
        }
        this.loadBalancerNames = new SdkInternalList(loadBalancerNames);
    }

    public AutoScalingGroup withLoadBalancerNames(String ... loadBalancerNames) {
        if (this.loadBalancerNames == null) {
            this.setLoadBalancerNames((Collection<String>)new SdkInternalList(loadBalancerNames.length));
        }
        for (String ele : loadBalancerNames) {
            this.loadBalancerNames.add((Object)ele);
        }
        return this;
    }

    public AutoScalingGroup withLoadBalancerNames(Collection<String> loadBalancerNames) {
        this.setLoadBalancerNames(loadBalancerNames);
        return this;
    }

    public List<String> getTargetGroupARNs() {
        if (this.targetGroupARNs == null) {
            this.targetGroupARNs = new SdkInternalList();
        }
        return this.targetGroupARNs;
    }

    public void setTargetGroupARNs(Collection<String> targetGroupARNs) {
        if (targetGroupARNs == null) {
            this.targetGroupARNs = null;
            return;
        }
        this.targetGroupARNs = new SdkInternalList(targetGroupARNs);
    }

    public AutoScalingGroup withTargetGroupARNs(String ... targetGroupARNs) {
        if (this.targetGroupARNs == null) {
            this.setTargetGroupARNs((Collection<String>)new SdkInternalList(targetGroupARNs.length));
        }
        for (String ele : targetGroupARNs) {
            this.targetGroupARNs.add((Object)ele);
        }
        return this;
    }

    public AutoScalingGroup withTargetGroupARNs(Collection<String> targetGroupARNs) {
        this.setTargetGroupARNs(targetGroupARNs);
        return this;
    }

    public void setHealthCheckType(String healthCheckType) {
        this.healthCheckType = healthCheckType;
    }

    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    public AutoScalingGroup withHealthCheckType(String healthCheckType) {
        this.setHealthCheckType(healthCheckType);
        return this;
    }

    public void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
        this.healthCheckGracePeriod = healthCheckGracePeriod;
    }

    public Integer getHealthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public AutoScalingGroup withHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
        this.setHealthCheckGracePeriod(healthCheckGracePeriod);
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new SdkInternalList();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new SdkInternalList(instances);
    }

    public AutoScalingGroup withInstances(Instance ... instances) {
        if (this.instances == null) {
            this.setInstances((Collection<Instance>)new SdkInternalList(instances.length));
        }
        for (Instance ele : instances) {
            this.instances.add((Object)ele);
        }
        return this;
    }

    public AutoScalingGroup withInstances(Collection<Instance> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public AutoScalingGroup withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public List<SuspendedProcess> getSuspendedProcesses() {
        if (this.suspendedProcesses == null) {
            this.suspendedProcesses = new SdkInternalList();
        }
        return this.suspendedProcesses;
    }

    public void setSuspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
        if (suspendedProcesses == null) {
            this.suspendedProcesses = null;
            return;
        }
        this.suspendedProcesses = new SdkInternalList(suspendedProcesses);
    }

    public AutoScalingGroup withSuspendedProcesses(SuspendedProcess ... suspendedProcesses) {
        if (this.suspendedProcesses == null) {
            this.setSuspendedProcesses((Collection<SuspendedProcess>)new SdkInternalList(suspendedProcesses.length));
        }
        for (SuspendedProcess ele : suspendedProcesses) {
            this.suspendedProcesses.add((Object)ele);
        }
        return this;
    }

    public AutoScalingGroup withSuspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
        this.setSuspendedProcesses(suspendedProcesses);
        return this;
    }

    public void setPlacementGroup(String placementGroup) {
        this.placementGroup = placementGroup;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public AutoScalingGroup withPlacementGroup(String placementGroup) {
        this.setPlacementGroup(placementGroup);
        return this;
    }

    public void setVPCZoneIdentifier(String vPCZoneIdentifier) {
        this.vPCZoneIdentifier = vPCZoneIdentifier;
    }

    public String getVPCZoneIdentifier() {
        return this.vPCZoneIdentifier;
    }

    public AutoScalingGroup withVPCZoneIdentifier(String vPCZoneIdentifier) {
        this.setVPCZoneIdentifier(vPCZoneIdentifier);
        return this;
    }

    public List<EnabledMetric> getEnabledMetrics() {
        if (this.enabledMetrics == null) {
            this.enabledMetrics = new SdkInternalList();
        }
        return this.enabledMetrics;
    }

    public void setEnabledMetrics(Collection<EnabledMetric> enabledMetrics) {
        if (enabledMetrics == null) {
            this.enabledMetrics = null;
            return;
        }
        this.enabledMetrics = new SdkInternalList(enabledMetrics);
    }

    public AutoScalingGroup withEnabledMetrics(EnabledMetric ... enabledMetrics) {
        if (this.enabledMetrics == null) {
            this.setEnabledMetrics((Collection<EnabledMetric>)new SdkInternalList(enabledMetrics.length));
        }
        for (EnabledMetric ele : enabledMetrics) {
            this.enabledMetrics.add((Object)ele);
        }
        return this;
    }

    public AutoScalingGroup withEnabledMetrics(Collection<EnabledMetric> enabledMetrics) {
        this.setEnabledMetrics(enabledMetrics);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public AutoScalingGroup withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public List<TagDescription> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<TagDescription> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public AutoScalingGroup withTags(TagDescription ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<TagDescription>)new SdkInternalList(tags.length));
        }
        for (TagDescription ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public AutoScalingGroup withTags(Collection<TagDescription> tags) {
        this.setTags(tags);
        return this;
    }

    public List<String> getTerminationPolicies() {
        if (this.terminationPolicies == null) {
            this.terminationPolicies = new SdkInternalList();
        }
        return this.terminationPolicies;
    }

    public void setTerminationPolicies(Collection<String> terminationPolicies) {
        if (terminationPolicies == null) {
            this.terminationPolicies = null;
            return;
        }
        this.terminationPolicies = new SdkInternalList(terminationPolicies);
    }

    public AutoScalingGroup withTerminationPolicies(String ... terminationPolicies) {
        if (this.terminationPolicies == null) {
            this.setTerminationPolicies((Collection<String>)new SdkInternalList(terminationPolicies.length));
        }
        for (String ele : terminationPolicies) {
            this.terminationPolicies.add((Object)ele);
        }
        return this;
    }

    public AutoScalingGroup withTerminationPolicies(Collection<String> terminationPolicies) {
        this.setTerminationPolicies(terminationPolicies);
        return this;
    }

    public void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
        this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
    }

    public Boolean getNewInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public AutoScalingGroup withNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
        this.setNewInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn);
        return this;
    }

    public Boolean isNewInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.getAutoScalingGroupName()).append(",");
        }
        if (this.getAutoScalingGroupARN() != null) {
            sb.append("AutoScalingGroupARN: ").append(this.getAutoScalingGroupARN()).append(",");
        }
        if (this.getLaunchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(this.getLaunchConfigurationName()).append(",");
        }
        if (this.getLaunchTemplate() != null) {
            sb.append("LaunchTemplate: ").append(this.getLaunchTemplate()).append(",");
        }
        if (this.getMinSize() != null) {
            sb.append("MinSize: ").append(this.getMinSize()).append(",");
        }
        if (this.getMaxSize() != null) {
            sb.append("MaxSize: ").append(this.getMaxSize()).append(",");
        }
        if (this.getDesiredCapacity() != null) {
            sb.append("DesiredCapacity: ").append(this.getDesiredCapacity()).append(",");
        }
        if (this.getDefaultCooldown() != null) {
            sb.append("DefaultCooldown: ").append(this.getDefaultCooldown()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getLoadBalancerNames() != null) {
            sb.append("LoadBalancerNames: ").append(this.getLoadBalancerNames()).append(",");
        }
        if (this.getTargetGroupARNs() != null) {
            sb.append("TargetGroupARNs: ").append(this.getTargetGroupARNs()).append(",");
        }
        if (this.getHealthCheckType() != null) {
            sb.append("HealthCheckType: ").append(this.getHealthCheckType()).append(",");
        }
        if (this.getHealthCheckGracePeriod() != null) {
            sb.append("HealthCheckGracePeriod: ").append(this.getHealthCheckGracePeriod()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getSuspendedProcesses() != null) {
            sb.append("SuspendedProcesses: ").append(this.getSuspendedProcesses()).append(",");
        }
        if (this.getPlacementGroup() != null) {
            sb.append("PlacementGroup: ").append(this.getPlacementGroup()).append(",");
        }
        if (this.getVPCZoneIdentifier() != null) {
            sb.append("VPCZoneIdentifier: ").append(this.getVPCZoneIdentifier()).append(",");
        }
        if (this.getEnabledMetrics() != null) {
            sb.append("EnabledMetrics: ").append(this.getEnabledMetrics()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTerminationPolicies() != null) {
            sb.append("TerminationPolicies: ").append(this.getTerminationPolicies()).append(",");
        }
        if (this.getNewInstancesProtectedFromScaleIn() != null) {
            sb.append("NewInstancesProtectedFromScaleIn: ").append(this.getNewInstancesProtectedFromScaleIn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getAutoScalingGroupARN() == null ^ this.getAutoScalingGroupARN() == null) {
            return false;
        }
        if (other.getAutoScalingGroupARN() != null && !other.getAutoScalingGroupARN().equals(this.getAutoScalingGroupARN())) {
            return false;
        }
        if (other.getLaunchConfigurationName() == null ^ this.getLaunchConfigurationName() == null) {
            return false;
        }
        if (other.getLaunchConfigurationName() != null && !other.getLaunchConfigurationName().equals(this.getLaunchConfigurationName())) {
            return false;
        }
        if (other.getLaunchTemplate() == null ^ this.getLaunchTemplate() == null) {
            return false;
        }
        if (other.getLaunchTemplate() != null && !other.getLaunchTemplate().equals(this.getLaunchTemplate())) {
            return false;
        }
        if (other.getMinSize() == null ^ this.getMinSize() == null) {
            return false;
        }
        if (other.getMinSize() != null && !other.getMinSize().equals(this.getMinSize())) {
            return false;
        }
        if (other.getMaxSize() == null ^ this.getMaxSize() == null) {
            return false;
        }
        if (other.getMaxSize() != null && !other.getMaxSize().equals(this.getMaxSize())) {
            return false;
        }
        if (other.getDesiredCapacity() == null ^ this.getDesiredCapacity() == null) {
            return false;
        }
        if (other.getDesiredCapacity() != null && !other.getDesiredCapacity().equals(this.getDesiredCapacity())) {
            return false;
        }
        if (other.getDefaultCooldown() == null ^ this.getDefaultCooldown() == null) {
            return false;
        }
        if (other.getDefaultCooldown() != null && !other.getDefaultCooldown().equals(this.getDefaultCooldown())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getLoadBalancerNames() == null ^ this.getLoadBalancerNames() == null) {
            return false;
        }
        if (other.getLoadBalancerNames() != null && !other.getLoadBalancerNames().equals(this.getLoadBalancerNames())) {
            return false;
        }
        if (other.getTargetGroupARNs() == null ^ this.getTargetGroupARNs() == null) {
            return false;
        }
        if (other.getTargetGroupARNs() != null && !other.getTargetGroupARNs().equals(this.getTargetGroupARNs())) {
            return false;
        }
        if (other.getHealthCheckType() == null ^ this.getHealthCheckType() == null) {
            return false;
        }
        if (other.getHealthCheckType() != null && !other.getHealthCheckType().equals(this.getHealthCheckType())) {
            return false;
        }
        if (other.getHealthCheckGracePeriod() == null ^ this.getHealthCheckGracePeriod() == null) {
            return false;
        }
        if (other.getHealthCheckGracePeriod() != null && !other.getHealthCheckGracePeriod().equals(this.getHealthCheckGracePeriod())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getSuspendedProcesses() == null ^ this.getSuspendedProcesses() == null) {
            return false;
        }
        if (other.getSuspendedProcesses() != null && !other.getSuspendedProcesses().equals(this.getSuspendedProcesses())) {
            return false;
        }
        if (other.getPlacementGroup() == null ^ this.getPlacementGroup() == null) {
            return false;
        }
        if (other.getPlacementGroup() != null && !other.getPlacementGroup().equals(this.getPlacementGroup())) {
            return false;
        }
        if (other.getVPCZoneIdentifier() == null ^ this.getVPCZoneIdentifier() == null) {
            return false;
        }
        if (other.getVPCZoneIdentifier() != null && !other.getVPCZoneIdentifier().equals(this.getVPCZoneIdentifier())) {
            return false;
        }
        if (other.getEnabledMetrics() == null ^ this.getEnabledMetrics() == null) {
            return false;
        }
        if (other.getEnabledMetrics() != null && !other.getEnabledMetrics().equals(this.getEnabledMetrics())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTerminationPolicies() == null ^ this.getTerminationPolicies() == null) {
            return false;
        }
        if (other.getTerminationPolicies() != null && !other.getTerminationPolicies().equals(this.getTerminationPolicies())) {
            return false;
        }
        if (other.getNewInstancesProtectedFromScaleIn() == null ^ this.getNewInstancesProtectedFromScaleIn() == null) {
            return false;
        }
        return other.getNewInstancesProtectedFromScaleIn() == null || other.getNewInstancesProtectedFromScaleIn().equals(this.getNewInstancesProtectedFromScaleIn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroupARN() == null ? 0 : this.getAutoScalingGroupARN().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchConfigurationName() == null ? 0 : this.getLaunchConfigurationName().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTemplate() == null ? 0 : this.getLaunchTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getMinSize() == null ? 0 : this.getMinSize().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSize() == null ? 0 : this.getMaxSize().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredCapacity() == null ? 0 : this.getDesiredCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultCooldown() == null ? 0 : this.getDefaultCooldown().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerNames() == null ? 0 : this.getLoadBalancerNames().hashCode());
        hashCode = 31 * hashCode + (this.getTargetGroupARNs() == null ? 0 : this.getTargetGroupARNs().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckType() == null ? 0 : this.getHealthCheckType().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckGracePeriod() == null ? 0 : this.getHealthCheckGracePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getSuspendedProcesses() == null ? 0 : this.getSuspendedProcesses().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementGroup() == null ? 0 : this.getPlacementGroup().hashCode());
        hashCode = 31 * hashCode + (this.getVPCZoneIdentifier() == null ? 0 : this.getVPCZoneIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getEnabledMetrics() == null ? 0 : this.getEnabledMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTerminationPolicies() == null ? 0 : this.getTerminationPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getNewInstancesProtectedFromScaleIn() == null ? 0 : this.getNewInstancesProtectedFromScaleIn().hashCode());
        return hashCode;
    }

    public AutoScalingGroup clone() {
        try {
            return (AutoScalingGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

