/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model.transform;

import com.amazonaws.services.auditmanager.model.Evidence;
import com.amazonaws.services.auditmanager.model.transform.ResourceJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class EvidenceJsonUnmarshaller
implements Unmarshaller<Evidence, JsonUnmarshallerContext> {
    private static EvidenceJsonUnmarshaller instance;

    public Evidence unmarshall(JsonUnmarshallerContext context) throws Exception {
        Evidence evidence = new Evidence();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("dataSource", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setDataSource((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("evidenceAwsAccountId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setEvidenceAwsAccountId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("time", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("eventSource", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setEventSource((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("eventName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setEventName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("evidenceByType", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setEvidenceByType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourcesIncluded", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setResourcesIncluded(new ListUnmarshaller((Unmarshaller)ResourceJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("attributes", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setAttributes(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("iamId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setIamId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("complianceCheck", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setComplianceCheck((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsOrganization", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setAwsOrganization((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsAccountId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setAwsAccountId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("evidenceFolderId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setEvidenceFolderId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("id", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("assessmentReportSelection", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    evidence.setAssessmentReportSelection((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return evidence;
    }

    public static EvidenceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EvidenceJsonUnmarshaller();
        }
        return instance;
    }
}

