/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.auditmanager.model.AWSAccount;
import com.amazonaws.services.auditmanager.model.AssessmentFramework;
import com.amazonaws.services.auditmanager.model.AssessmentMetadata;
import com.amazonaws.services.auditmanager.model.transform.AssessmentMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Assessment
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private AWSAccount awsAccount;
    private AssessmentMetadata metadata;
    private AssessmentFramework framework;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Assessment withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setAwsAccount(AWSAccount awsAccount) {
        this.awsAccount = awsAccount;
    }

    public AWSAccount getAwsAccount() {
        return this.awsAccount;
    }

    public Assessment withAwsAccount(AWSAccount awsAccount) {
        this.setAwsAccount(awsAccount);
        return this;
    }

    public void setMetadata(AssessmentMetadata metadata) {
        this.metadata = metadata;
    }

    public AssessmentMetadata getMetadata() {
        return this.metadata;
    }

    public Assessment withMetadata(AssessmentMetadata metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public void setFramework(AssessmentFramework framework) {
        this.framework = framework;
    }

    public AssessmentFramework getFramework() {
        return this.framework;
    }

    public Assessment withFramework(AssessmentFramework framework) {
        this.setFramework(framework);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Assessment withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Assessment addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Assessment clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAwsAccount() != null) {
            sb.append("AwsAccount: ").append(this.getAwsAccount()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata()).append(",");
        }
        if (this.getFramework() != null) {
            sb.append("Framework: ").append(this.getFramework()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Assessment)) {
            return false;
        }
        Assessment other = (Assessment)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAwsAccount() == null ^ this.getAwsAccount() == null) {
            return false;
        }
        if (other.getAwsAccount() != null && !other.getAwsAccount().equals(this.getAwsAccount())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getFramework() == null ^ this.getFramework() == null) {
            return false;
        }
        if (other.getFramework() != null && !other.getFramework().equals(this.getFramework())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAwsAccount() == null ? 0 : this.getAwsAccount().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getFramework() == null ? 0 : this.getFramework().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Assessment clone() {
        try {
            return (Assessment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssessmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

