/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.athena.model.TableMetadata;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class TableMetadataMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Date> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTACCESSTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAccessTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> TABLETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableType").build();
    private static final MarshallingInfo<List> COLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Columns").build();
    private static final MarshallingInfo<List> PARTITIONKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionKeys").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final TableMetadataMarshaller instance = new TableMetadataMarshaller();

    public static TableMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(TableMetadata tableMetadata, ProtocolMarshaller protocolMarshaller) {
        if (tableMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tableMetadata.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)tableMetadata.getCreateTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall((Object)tableMetadata.getLastAccessTime(), LASTACCESSTIME_BINDING);
            protocolMarshaller.marshall((Object)tableMetadata.getTableType(), TABLETYPE_BINDING);
            protocolMarshaller.marshall(tableMetadata.getColumns(), COLUMNS_BINDING);
            protocolMarshaller.marshall(tableMetadata.getPartitionKeys(), PARTITIONKEYS_BINDING);
            protocolMarshaller.marshall(tableMetadata.getParameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

