/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListSessions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListSessionsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The workgroup to which the session belongs.
     * </p>
     */
    private String workGroup;
    /**
     * <p>
     * A filter for a specific session state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The session is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The session has been started.
     * </p>
     * <p>
     * <code>IDLE</code> - The session is able to accept a calculation.
     * </p>
     * <p>
     * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The session is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The session and its resources are no longer running.
     * </p>
     * <p>
     * <code>DEGRADED</code> - The session has no healthy coordinators.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * </p>
     */
    private String stateFilter;
    /**
     * <p>
     * The maximum number of sessions to return.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The workgroup to which the session belongs.
     * </p>
     * 
     * @param workGroup
     *        The workgroup to which the session belongs.
     */

    public void setWorkGroup(String workGroup) {
        this.workGroup = workGroup;
    }

    /**
     * <p>
     * The workgroup to which the session belongs.
     * </p>
     * 
     * @return The workgroup to which the session belongs.
     */

    public String getWorkGroup() {
        return this.workGroup;
    }

    /**
     * <p>
     * The workgroup to which the session belongs.
     * </p>
     * 
     * @param workGroup
     *        The workgroup to which the session belongs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSessionsRequest withWorkGroup(String workGroup) {
        setWorkGroup(workGroup);
        return this;
    }

    /**
     * <p>
     * A filter for a specific session state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The session is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The session has been started.
     * </p>
     * <p>
     * <code>IDLE</code> - The session is able to accept a calculation.
     * </p>
     * <p>
     * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The session is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The session and its resources are no longer running.
     * </p>
     * <p>
     * <code>DEGRADED</code> - The session has no healthy coordinators.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * </p>
     * 
     * @param stateFilter
     *        A filter for a specific session state. A description of each state follows.</p>
     *        <p>
     *        <code>CREATING</code> - The session is being started, including acquiring resources.
     *        </p>
     *        <p>
     *        <code>CREATED</code> - The session has been started.
     *        </p>
     *        <p>
     *        <code>IDLE</code> - The session is able to accept a calculation.
     *        </p>
     *        <p>
     *        <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     *        </p>
     *        <p>
     *        <code>TERMINATING</code> - The session is in the process of shutting down.
     *        </p>
     *        <p>
     *        <code>TERMINATED</code> - The session and its resources are no longer running.
     *        </p>
     *        <p>
     *        <code>DEGRADED</code> - The session has no healthy coordinators.
     *        </p>
     *        <p>
     *        <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * @see SessionState
     */

    public void setStateFilter(String stateFilter) {
        this.stateFilter = stateFilter;
    }

    /**
     * <p>
     * A filter for a specific session state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The session is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The session has been started.
     * </p>
     * <p>
     * <code>IDLE</code> - The session is able to accept a calculation.
     * </p>
     * <p>
     * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The session is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The session and its resources are no longer running.
     * </p>
     * <p>
     * <code>DEGRADED</code> - The session has no healthy coordinators.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * </p>
     * 
     * @return A filter for a specific session state. A description of each state follows.</p>
     *         <p>
     *         <code>CREATING</code> - The session is being started, including acquiring resources.
     *         </p>
     *         <p>
     *         <code>CREATED</code> - The session has been started.
     *         </p>
     *         <p>
     *         <code>IDLE</code> - The session is able to accept a calculation.
     *         </p>
     *         <p>
     *         <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     *         </p>
     *         <p>
     *         <code>TERMINATING</code> - The session is in the process of shutting down.
     *         </p>
     *         <p>
     *         <code>TERMINATED</code> - The session and its resources are no longer running.
     *         </p>
     *         <p>
     *         <code>DEGRADED</code> - The session has no healthy coordinators.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * @see SessionState
     */

    public String getStateFilter() {
        return this.stateFilter;
    }

    /**
     * <p>
     * A filter for a specific session state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The session is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The session has been started.
     * </p>
     * <p>
     * <code>IDLE</code> - The session is able to accept a calculation.
     * </p>
     * <p>
     * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The session is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The session and its resources are no longer running.
     * </p>
     * <p>
     * <code>DEGRADED</code> - The session has no healthy coordinators.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * </p>
     * 
     * @param stateFilter
     *        A filter for a specific session state. A description of each state follows.</p>
     *        <p>
     *        <code>CREATING</code> - The session is being started, including acquiring resources.
     *        </p>
     *        <p>
     *        <code>CREATED</code> - The session has been started.
     *        </p>
     *        <p>
     *        <code>IDLE</code> - The session is able to accept a calculation.
     *        </p>
     *        <p>
     *        <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     *        </p>
     *        <p>
     *        <code>TERMINATING</code> - The session is in the process of shutting down.
     *        </p>
     *        <p>
     *        <code>TERMINATED</code> - The session and its resources are no longer running.
     *        </p>
     *        <p>
     *        <code>DEGRADED</code> - The session has no healthy coordinators.
     *        </p>
     *        <p>
     *        <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SessionState
     */

    public ListSessionsRequest withStateFilter(String stateFilter) {
        setStateFilter(stateFilter);
        return this;
    }

    /**
     * <p>
     * A filter for a specific session state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The session is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The session has been started.
     * </p>
     * <p>
     * <code>IDLE</code> - The session is able to accept a calculation.
     * </p>
     * <p>
     * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The session is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The session and its resources are no longer running.
     * </p>
     * <p>
     * <code>DEGRADED</code> - The session has no healthy coordinators.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * </p>
     * 
     * @param stateFilter
     *        A filter for a specific session state. A description of each state follows.</p>
     *        <p>
     *        <code>CREATING</code> - The session is being started, including acquiring resources.
     *        </p>
     *        <p>
     *        <code>CREATED</code> - The session has been started.
     *        </p>
     *        <p>
     *        <code>IDLE</code> - The session is able to accept a calculation.
     *        </p>
     *        <p>
     *        <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     *        </p>
     *        <p>
     *        <code>TERMINATING</code> - The session is in the process of shutting down.
     *        </p>
     *        <p>
     *        <code>TERMINATED</code> - The session and its resources are no longer running.
     *        </p>
     *        <p>
     *        <code>DEGRADED</code> - The session has no healthy coordinators.
     *        </p>
     *        <p>
     *        <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SessionState
     */

    public ListSessionsRequest withStateFilter(SessionState stateFilter) {
        this.stateFilter = stateFilter.toString();
        return this;
    }

    /**
     * <p>
     * The maximum number of sessions to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of sessions to return.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of sessions to return.
     * </p>
     * 
     * @return The maximum number of sessions to return.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of sessions to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of sessions to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSessionsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSessionsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getWorkGroup() != null)
            sb.append("WorkGroup: ").append(getWorkGroup()).append(",");
        if (getStateFilter() != null)
            sb.append("StateFilter: ").append(getStateFilter()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListSessionsRequest == false)
            return false;
        ListSessionsRequest other = (ListSessionsRequest) obj;
        if (other.getWorkGroup() == null ^ this.getWorkGroup() == null)
            return false;
        if (other.getWorkGroup() != null && other.getWorkGroup().equals(this.getWorkGroup()) == false)
            return false;
        if (other.getStateFilter() == null ^ this.getStateFilter() == null)
            return false;
        if (other.getStateFilter() != null && other.getStateFilter().equals(this.getStateFilter()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getWorkGroup() == null) ? 0 : getWorkGroup().hashCode());
        hashCode = prime * hashCode + ((getStateFilter() == null) ? 0 : getStateFilter().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListSessionsRequest clone() {
        return (ListSessionsRequest) super.clone();
    }

}
