/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.artifact.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.artifact.model.ReportSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListReportsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ReportSummary> reports;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListReportsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ReportSummary> getReports() {
        return this.reports;
    }

    public void setReports(Collection<ReportSummary> reports) {
        if (reports == null) {
            this.reports = null;
            return;
        }
        this.reports = new ArrayList<ReportSummary>(reports);
    }

    public ListReportsResult withReports(ReportSummary ... reports) {
        if (this.reports == null) {
            this.setReports(new ArrayList<ReportSummary>(reports.length));
        }
        for (ReportSummary ele : reports) {
            this.reports.add(ele);
        }
        return this;
    }

    public ListReportsResult withReports(Collection<ReportSummary> reports) {
        this.setReports(reports);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getReports() != null) {
            sb.append("Reports: ").append(this.getReports());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportsResult)) {
            return false;
        }
        ListReportsResult other = (ListReportsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getReports() == null ^ this.getReports() == null) {
            return false;
        }
        return other.getReports() == null || other.getReports().equals(this.getReports());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getReports() == null ? 0 : this.getReports().hashCode());
        return hashCode;
    }

    public ListReportsResult clone() {
        try {
            return (ListReportsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

