/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.apptest.model.TestCaseSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTestCasesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<TestCaseSummary> testCases;
    private String nextToken;

    public List<TestCaseSummary> getTestCases() {
        return this.testCases;
    }

    public void setTestCases(Collection<TestCaseSummary> testCases) {
        if (testCases == null) {
            this.testCases = null;
            return;
        }
        this.testCases = new ArrayList<TestCaseSummary>(testCases);
    }

    public ListTestCasesResult withTestCases(TestCaseSummary ... testCases) {
        if (this.testCases == null) {
            this.setTestCases(new ArrayList<TestCaseSummary>(testCases.length));
        }
        for (TestCaseSummary ele : testCases) {
            this.testCases.add(ele);
        }
        return this;
    }

    public ListTestCasesResult withTestCases(Collection<TestCaseSummary> testCases) {
        this.setTestCases(testCases);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTestCasesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTestCases() != null) {
            sb.append("TestCases: ").append(this.getTestCases()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestCasesResult)) {
            return false;
        }
        ListTestCasesResult other = (ListTestCasesResult)obj;
        if (other.getTestCases() == null ^ this.getTestCases() == null) {
            return false;
        }
        if (other.getTestCases() != null && !other.getTestCases().equals(this.getTestCases())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTestCases() == null ? 0 : this.getTestCases().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTestCasesResult clone() {
        try {
            return (ListTestCasesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

