/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTestRunsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String testSuiteId;
    private List<String> testRunIds;
    private String nextToken;
    private Integer maxResults;

    public void setTestSuiteId(String testSuiteId) {
        this.testSuiteId = testSuiteId;
    }

    public String getTestSuiteId() {
        return this.testSuiteId;
    }

    public ListTestRunsRequest withTestSuiteId(String testSuiteId) {
        this.setTestSuiteId(testSuiteId);
        return this;
    }

    public List<String> getTestRunIds() {
        return this.testRunIds;
    }

    public void setTestRunIds(Collection<String> testRunIds) {
        if (testRunIds == null) {
            this.testRunIds = null;
            return;
        }
        this.testRunIds = new ArrayList<String>(testRunIds);
    }

    public ListTestRunsRequest withTestRunIds(String ... testRunIds) {
        if (this.testRunIds == null) {
            this.setTestRunIds(new ArrayList<String>(testRunIds.length));
        }
        for (String ele : testRunIds) {
            this.testRunIds.add(ele);
        }
        return this;
    }

    public ListTestRunsRequest withTestRunIds(Collection<String> testRunIds) {
        this.setTestRunIds(testRunIds);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTestRunsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListTestRunsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTestSuiteId() != null) {
            sb.append("TestSuiteId: ").append(this.getTestSuiteId()).append(",");
        }
        if (this.getTestRunIds() != null) {
            sb.append("TestRunIds: ").append(this.getTestRunIds()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestRunsRequest)) {
            return false;
        }
        ListTestRunsRequest other = (ListTestRunsRequest)obj;
        if (other.getTestSuiteId() == null ^ this.getTestSuiteId() == null) {
            return false;
        }
        if (other.getTestSuiteId() != null && !other.getTestSuiteId().equals(this.getTestSuiteId())) {
            return false;
        }
        if (other.getTestRunIds() == null ^ this.getTestRunIds() == null) {
            return false;
        }
        if (other.getTestRunIds() != null && !other.getTestRunIds().equals(this.getTestRunIds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTestSuiteId() == null ? 0 : this.getTestSuiteId().hashCode());
        hashCode = 31 * hashCode + (this.getTestRunIds() == null ? 0 : this.getTestRunIds().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public ListTestRunsRequest clone() {
        return (ListTestRunsRequest)super.clone();
    }
}

