/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appsync.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSourceApiAssociation" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetSourceApiAssociationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The <code>SourceApiAssociation</code> object data.
     * </p>
     */
    private SourceApiAssociation sourceApiAssociation;

    /**
     * <p>
     * The <code>SourceApiAssociation</code> object data.
     * </p>
     * 
     * @param sourceApiAssociation
     *        The <code>SourceApiAssociation</code> object data.
     */

    public void setSourceApiAssociation(SourceApiAssociation sourceApiAssociation) {
        this.sourceApiAssociation = sourceApiAssociation;
    }

    /**
     * <p>
     * The <code>SourceApiAssociation</code> object data.
     * </p>
     * 
     * @return The <code>SourceApiAssociation</code> object data.
     */

    public SourceApiAssociation getSourceApiAssociation() {
        return this.sourceApiAssociation;
    }

    /**
     * <p>
     * The <code>SourceApiAssociation</code> object data.
     * </p>
     * 
     * @param sourceApiAssociation
     *        The <code>SourceApiAssociation</code> object data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetSourceApiAssociationResult withSourceApiAssociation(SourceApiAssociation sourceApiAssociation) {
        setSourceApiAssociation(sourceApiAssociation);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSourceApiAssociation() != null)
            sb.append("SourceApiAssociation: ").append(getSourceApiAssociation());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetSourceApiAssociationResult == false)
            return false;
        GetSourceApiAssociationResult other = (GetSourceApiAssociationResult) obj;
        if (other.getSourceApiAssociation() == null ^ this.getSourceApiAssociation() == null)
            return false;
        if (other.getSourceApiAssociation() != null && other.getSourceApiAssociation().equals(this.getSourceApiAssociation()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSourceApiAssociation() == null) ? 0 : getSourceApiAssociation().hashCode());
        return hashCode;
    }

    @Override
    public GetSourceApiAssociationResult clone() {
        try {
            return (GetSourceApiAssociationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
