/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.appsync.model.FunctionConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListFunctionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<FunctionConfiguration> functions;
    private String nextToken;

    public List<FunctionConfiguration> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Collection<FunctionConfiguration> functions) {
        if (functions == null) {
            this.functions = null;
            return;
        }
        this.functions = new ArrayList<FunctionConfiguration>(functions);
    }

    public ListFunctionsResult withFunctions(FunctionConfiguration ... functions) {
        if (this.functions == null) {
            this.setFunctions(new ArrayList<FunctionConfiguration>(functions.length));
        }
        for (FunctionConfiguration ele : functions) {
            this.functions.add(ele);
        }
        return this;
    }

    public ListFunctionsResult withFunctions(Collection<FunctionConfiguration> functions) {
        this.setFunctions(functions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFunctionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctions() != null) {
            sb.append("Functions: ").append(this.getFunctions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsResult)) {
            return false;
        }
        ListFunctionsResult other = (ListFunctionsResult)obj;
        if (other.getFunctions() == null ^ this.getFunctions() == null) {
            return false;
        }
        if (other.getFunctions() != null && !other.getFunctions().equals(this.getFunctions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctions() == null ? 0 : this.getFunctions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListFunctionsResult clone() {
        try {
            return (ListFunctionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

