/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appstream.model.PlatformType;
import com.amazonaws.services.appstream.model.S3Location;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String displayName;
    private String description;
    private S3Location iconS3Location;
    private String launchPath;
    private String workingDirectory;
    private String launchParameters;
    private List<String> platforms;
    private List<String> instanceFamilies;
    private String appBlockArn;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateApplicationRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreateApplicationRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateApplicationRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setIconS3Location(S3Location iconS3Location) {
        this.iconS3Location = iconS3Location;
    }

    public S3Location getIconS3Location() {
        return this.iconS3Location;
    }

    public CreateApplicationRequest withIconS3Location(S3Location iconS3Location) {
        this.setIconS3Location(iconS3Location);
        return this;
    }

    public void setLaunchPath(String launchPath) {
        this.launchPath = launchPath;
    }

    public String getLaunchPath() {
        return this.launchPath;
    }

    public CreateApplicationRequest withLaunchPath(String launchPath) {
        this.setLaunchPath(launchPath);
        return this;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public CreateApplicationRequest withWorkingDirectory(String workingDirectory) {
        this.setWorkingDirectory(workingDirectory);
        return this;
    }

    public void setLaunchParameters(String launchParameters) {
        this.launchParameters = launchParameters;
    }

    public String getLaunchParameters() {
        return this.launchParameters;
    }

    public CreateApplicationRequest withLaunchParameters(String launchParameters) {
        this.setLaunchParameters(launchParameters);
        return this;
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(Collection<String> platforms) {
        if (platforms == null) {
            this.platforms = null;
            return;
        }
        this.platforms = new ArrayList<String>(platforms);
    }

    public CreateApplicationRequest withPlatforms(String ... platforms) {
        if (this.platforms == null) {
            this.setPlatforms(new ArrayList<String>(platforms.length));
        }
        for (String ele : platforms) {
            this.platforms.add(ele);
        }
        return this;
    }

    public CreateApplicationRequest withPlatforms(Collection<String> platforms) {
        this.setPlatforms(platforms);
        return this;
    }

    public CreateApplicationRequest withPlatforms(PlatformType ... platforms) {
        ArrayList<String> platformsCopy = new ArrayList<String>(platforms.length);
        for (PlatformType value : platforms) {
            platformsCopy.add(value.toString());
        }
        if (this.getPlatforms() == null) {
            this.setPlatforms(platformsCopy);
        } else {
            this.getPlatforms().addAll(platformsCopy);
        }
        return this;
    }

    public List<String> getInstanceFamilies() {
        return this.instanceFamilies;
    }

    public void setInstanceFamilies(Collection<String> instanceFamilies) {
        if (instanceFamilies == null) {
            this.instanceFamilies = null;
            return;
        }
        this.instanceFamilies = new ArrayList<String>(instanceFamilies);
    }

    public CreateApplicationRequest withInstanceFamilies(String ... instanceFamilies) {
        if (this.instanceFamilies == null) {
            this.setInstanceFamilies(new ArrayList<String>(instanceFamilies.length));
        }
        for (String ele : instanceFamilies) {
            this.instanceFamilies.add(ele);
        }
        return this;
    }

    public CreateApplicationRequest withInstanceFamilies(Collection<String> instanceFamilies) {
        this.setInstanceFamilies(instanceFamilies);
        return this;
    }

    public void setAppBlockArn(String appBlockArn) {
        this.appBlockArn = appBlockArn;
    }

    public String getAppBlockArn() {
        return this.appBlockArn;
    }

    public CreateApplicationRequest withAppBlockArn(String appBlockArn) {
        this.setAppBlockArn(appBlockArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateApplicationRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateApplicationRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateApplicationRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getIconS3Location() != null) {
            sb.append("IconS3Location: ").append(this.getIconS3Location()).append(",");
        }
        if (this.getLaunchPath() != null) {
            sb.append("LaunchPath: ").append(this.getLaunchPath()).append(",");
        }
        if (this.getWorkingDirectory() != null) {
            sb.append("WorkingDirectory: ").append(this.getWorkingDirectory()).append(",");
        }
        if (this.getLaunchParameters() != null) {
            sb.append("LaunchParameters: ").append(this.getLaunchParameters()).append(",");
        }
        if (this.getPlatforms() != null) {
            sb.append("Platforms: ").append(this.getPlatforms()).append(",");
        }
        if (this.getInstanceFamilies() != null) {
            sb.append("InstanceFamilies: ").append(this.getInstanceFamilies()).append(",");
        }
        if (this.getAppBlockArn() != null) {
            sb.append("AppBlockArn: ").append(this.getAppBlockArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getIconS3Location() == null ^ this.getIconS3Location() == null) {
            return false;
        }
        if (other.getIconS3Location() != null && !other.getIconS3Location().equals(this.getIconS3Location())) {
            return false;
        }
        if (other.getLaunchPath() == null ^ this.getLaunchPath() == null) {
            return false;
        }
        if (other.getLaunchPath() != null && !other.getLaunchPath().equals(this.getLaunchPath())) {
            return false;
        }
        if (other.getWorkingDirectory() == null ^ this.getWorkingDirectory() == null) {
            return false;
        }
        if (other.getWorkingDirectory() != null && !other.getWorkingDirectory().equals(this.getWorkingDirectory())) {
            return false;
        }
        if (other.getLaunchParameters() == null ^ this.getLaunchParameters() == null) {
            return false;
        }
        if (other.getLaunchParameters() != null && !other.getLaunchParameters().equals(this.getLaunchParameters())) {
            return false;
        }
        if (other.getPlatforms() == null ^ this.getPlatforms() == null) {
            return false;
        }
        if (other.getPlatforms() != null && !other.getPlatforms().equals(this.getPlatforms())) {
            return false;
        }
        if (other.getInstanceFamilies() == null ^ this.getInstanceFamilies() == null) {
            return false;
        }
        if (other.getInstanceFamilies() != null && !other.getInstanceFamilies().equals(this.getInstanceFamilies())) {
            return false;
        }
        if (other.getAppBlockArn() == null ^ this.getAppBlockArn() == null) {
            return false;
        }
        if (other.getAppBlockArn() != null && !other.getAppBlockArn().equals(this.getAppBlockArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getIconS3Location() == null ? 0 : this.getIconS3Location().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchPath() == null ? 0 : this.getLaunchPath().hashCode());
        hashCode = 31 * hashCode + (this.getWorkingDirectory() == null ? 0 : this.getWorkingDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchParameters() == null ? 0 : this.getLaunchParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPlatforms() == null ? 0 : this.getPlatforms().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceFamilies() == null ? 0 : this.getInstanceFamilies().hashCode());
        hashCode = 31 * hashCode + (this.getAppBlockArn() == null ? 0 : this.getAppBlockArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateApplicationRequest clone() {
        return (CreateApplicationRequest)super.clone();
    }
}

