/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.CertificateBasedAuthProperties;
import com.amazonaws.services.appstream.model.ServiceAccountCredentials;
import com.amazonaws.services.appstream.model.transform.DirectoryConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DirectoryConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String directoryName;
    private List<String> organizationalUnitDistinguishedNames;
    private ServiceAccountCredentials serviceAccountCredentials;
    private Date createdTime;
    private CertificateBasedAuthProperties certificateBasedAuthProperties;

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public DirectoryConfig withDirectoryName(String directoryName) {
        this.setDirectoryName(directoryName);
        return this;
    }

    public List<String> getOrganizationalUnitDistinguishedNames() {
        return this.organizationalUnitDistinguishedNames;
    }

    public void setOrganizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
        if (organizationalUnitDistinguishedNames == null) {
            this.organizationalUnitDistinguishedNames = null;
            return;
        }
        this.organizationalUnitDistinguishedNames = new ArrayList<String>(organizationalUnitDistinguishedNames);
    }

    public DirectoryConfig withOrganizationalUnitDistinguishedNames(String ... organizationalUnitDistinguishedNames) {
        if (this.organizationalUnitDistinguishedNames == null) {
            this.setOrganizationalUnitDistinguishedNames(new ArrayList<String>(organizationalUnitDistinguishedNames.length));
        }
        for (String ele : organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames.add(ele);
        }
        return this;
    }

    public DirectoryConfig withOrganizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
        this.setOrganizationalUnitDistinguishedNames(organizationalUnitDistinguishedNames);
        return this;
    }

    public void setServiceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials) {
        this.serviceAccountCredentials = serviceAccountCredentials;
    }

    public ServiceAccountCredentials getServiceAccountCredentials() {
        return this.serviceAccountCredentials;
    }

    public DirectoryConfig withServiceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials) {
        this.setServiceAccountCredentials(serviceAccountCredentials);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public DirectoryConfig withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setCertificateBasedAuthProperties(CertificateBasedAuthProperties certificateBasedAuthProperties) {
        this.certificateBasedAuthProperties = certificateBasedAuthProperties;
    }

    public CertificateBasedAuthProperties getCertificateBasedAuthProperties() {
        return this.certificateBasedAuthProperties;
    }

    public DirectoryConfig withCertificateBasedAuthProperties(CertificateBasedAuthProperties certificateBasedAuthProperties) {
        this.setCertificateBasedAuthProperties(certificateBasedAuthProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryName() != null) {
            sb.append("DirectoryName: ").append(this.getDirectoryName()).append(",");
        }
        if (this.getOrganizationalUnitDistinguishedNames() != null) {
            sb.append("OrganizationalUnitDistinguishedNames: ").append(this.getOrganizationalUnitDistinguishedNames()).append(",");
        }
        if (this.getServiceAccountCredentials() != null) {
            sb.append("ServiceAccountCredentials: ").append(this.getServiceAccountCredentials()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getCertificateBasedAuthProperties() != null) {
            sb.append("CertificateBasedAuthProperties: ").append(this.getCertificateBasedAuthProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryConfig)) {
            return false;
        }
        DirectoryConfig other = (DirectoryConfig)obj;
        if (other.getDirectoryName() == null ^ this.getDirectoryName() == null) {
            return false;
        }
        if (other.getDirectoryName() != null && !other.getDirectoryName().equals(this.getDirectoryName())) {
            return false;
        }
        if (other.getOrganizationalUnitDistinguishedNames() == null ^ this.getOrganizationalUnitDistinguishedNames() == null) {
            return false;
        }
        if (other.getOrganizationalUnitDistinguishedNames() != null && !other.getOrganizationalUnitDistinguishedNames().equals(this.getOrganizationalUnitDistinguishedNames())) {
            return false;
        }
        if (other.getServiceAccountCredentials() == null ^ this.getServiceAccountCredentials() == null) {
            return false;
        }
        if (other.getServiceAccountCredentials() != null && !other.getServiceAccountCredentials().equals(this.getServiceAccountCredentials())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getCertificateBasedAuthProperties() == null ^ this.getCertificateBasedAuthProperties() == null) {
            return false;
        }
        return other.getCertificateBasedAuthProperties() == null || other.getCertificateBasedAuthProperties().equals(this.getCertificateBasedAuthProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryName() == null ? 0 : this.getDirectoryName().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationalUnitDistinguishedNames() == null ? 0 : this.getOrganizationalUnitDistinguishedNames().hashCode());
        hashCode = 31 * hashCode + (this.getServiceAccountCredentials() == null ? 0 : this.getServiceAccountCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateBasedAuthProperties() == null ? 0 : this.getCertificateBasedAuthProperties().hashCode());
        return hashCode;
    }

    public DirectoryConfig clone() {
        try {
            return (DirectoryConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectoryConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

