/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>Amazon AppStream 2.0</fullname>
 * <p>
 * This is the <i>Amazon AppStream 2.0 API Reference</i>. This documentation provides descriptions and syntax for each
 * of the actions and data types in AppStream 2.0. AppStream 2.0 is a fully managed, secure application streaming
 * service that lets you stream desktop applications to users without rewriting applications. AppStream 2.0 manages the
 * AWS resources that are required to host and run your applications, scales automatically, and provides access to your
 * users on demand.
 * </p>
 * <note>
 * <p>
 * You can call the AppStream 2.0 API operations by using an interface VPC endpoint (interface endpoint). For more
 * information, see <a href=
 * "https://docs.aws.amazon.com/appstream2/latest/developerguide/access-api-cli-through-interface-vpc-endpoint.html"
 * >Access AppStream 2.0 API Operations and CLI Commands Through an Interface VPC Endpoint</a> in the <i>Amazon
 * AppStream 2.0 Administration Guide</i>.
 * </p>
 * </note>
 * <p>
 * To learn more about AppStream 2.0, see the following resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="http://aws.amazon.com/appstream2">Amazon AppStream 2.0 product page</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="http://aws.amazon.com/documentation/appstream2">Amazon AppStream 2.0 documentation</a>
 * </p>
 * </li>
 * </ul>
 */
package com.amazonaws.services.appstream;

