/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appstream.model.ResourceError;
import java.util.Date;

@SdkInternalApi
public class ResourceErrorMarshaller {
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<Date> ERRORTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorTimestamp").timestampFormat("unixTimestamp").build();
    private static final ResourceErrorMarshaller instance = new ResourceErrorMarshaller();

    public static ResourceErrorMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceError resourceError, ProtocolMarshaller protocolMarshaller) {
        if (resourceError == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceError.getErrorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)resourceError.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)resourceError.getErrorTimestamp(), ERRORTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

