/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apprunner.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apprunner.model.Runtime;
import com.amazonaws.services.apprunner.model.transform.CodeConfigurationValuesMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CodeConfigurationValues
implements Serializable,
Cloneable,
StructuredPojo {
    private String runtime;
    private String buildCommand;
    private String startCommand;
    private String port;
    private Map<String, String> runtimeEnvironmentVariables;

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public CodeConfigurationValues withRuntime(String runtime) {
        this.setRuntime(runtime);
        return this;
    }

    public CodeConfigurationValues withRuntime(Runtime runtime) {
        this.runtime = runtime.toString();
        return this;
    }

    public void setBuildCommand(String buildCommand) {
        this.buildCommand = buildCommand;
    }

    public String getBuildCommand() {
        return this.buildCommand;
    }

    public CodeConfigurationValues withBuildCommand(String buildCommand) {
        this.setBuildCommand(buildCommand);
        return this;
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public CodeConfigurationValues withStartCommand(String startCommand) {
        this.setStartCommand(startCommand);
        return this;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPort() {
        return this.port;
    }

    public CodeConfigurationValues withPort(String port) {
        this.setPort(port);
        return this;
    }

    public Map<String, String> getRuntimeEnvironmentVariables() {
        return this.runtimeEnvironmentVariables;
    }

    public void setRuntimeEnvironmentVariables(Map<String, String> runtimeEnvironmentVariables) {
        this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
    }

    public CodeConfigurationValues withRuntimeEnvironmentVariables(Map<String, String> runtimeEnvironmentVariables) {
        this.setRuntimeEnvironmentVariables(runtimeEnvironmentVariables);
        return this;
    }

    public CodeConfigurationValues addRuntimeEnvironmentVariablesEntry(String key, String value) {
        if (null == this.runtimeEnvironmentVariables) {
            this.runtimeEnvironmentVariables = new HashMap<String, String>();
        }
        if (this.runtimeEnvironmentVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.runtimeEnvironmentVariables.put(key, value);
        return this;
    }

    public CodeConfigurationValues clearRuntimeEnvironmentVariablesEntries() {
        this.runtimeEnvironmentVariables = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuntime() != null) {
            sb.append("Runtime: ").append(this.getRuntime()).append(",");
        }
        if (this.getBuildCommand() != null) {
            sb.append("BuildCommand: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStartCommand() != null) {
            sb.append("StartCommand: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getRuntimeEnvironmentVariables() != null) {
            sb.append("RuntimeEnvironmentVariables: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeConfigurationValues)) {
            return false;
        }
        CodeConfigurationValues other = (CodeConfigurationValues)obj;
        if (other.getRuntime() == null ^ this.getRuntime() == null) {
            return false;
        }
        if (other.getRuntime() != null && !other.getRuntime().equals(this.getRuntime())) {
            return false;
        }
        if (other.getBuildCommand() == null ^ this.getBuildCommand() == null) {
            return false;
        }
        if (other.getBuildCommand() != null && !other.getBuildCommand().equals(this.getBuildCommand())) {
            return false;
        }
        if (other.getStartCommand() == null ^ this.getStartCommand() == null) {
            return false;
        }
        if (other.getStartCommand() != null && !other.getStartCommand().equals(this.getStartCommand())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getRuntimeEnvironmentVariables() == null ^ this.getRuntimeEnvironmentVariables() == null) {
            return false;
        }
        return other.getRuntimeEnvironmentVariables() == null || other.getRuntimeEnvironmentVariables().equals(this.getRuntimeEnvironmentVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuntime() == null ? 0 : this.getRuntime().hashCode());
        hashCode = 31 * hashCode + (this.getBuildCommand() == null ? 0 : this.getBuildCommand().hashCode());
        hashCode = 31 * hashCode + (this.getStartCommand() == null ? 0 : this.getStartCommand().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getRuntimeEnvironmentVariables() == null ? 0 : this.getRuntimeEnvironmentVariables().hashCode());
        return hashCode;
    }

    public CodeConfigurationValues clone() {
        try {
            return (CodeConfigurationValues)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeConfigurationValuesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

