/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appregistry.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/PutConfiguration" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutConfigurationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Associates a <code>TagKey</code> configuration to an account.
     * </p>
     */
    private AppRegistryConfiguration configuration;

    /**
     * <p>
     * Associates a <code>TagKey</code> configuration to an account.
     * </p>
     * 
     * @param configuration
     *        Associates a <code>TagKey</code> configuration to an account.
     */

    public void setConfiguration(AppRegistryConfiguration configuration) {
        this.configuration = configuration;
    }

    /**
     * <p>
     * Associates a <code>TagKey</code> configuration to an account.
     * </p>
     * 
     * @return Associates a <code>TagKey</code> configuration to an account.
     */

    public AppRegistryConfiguration getConfiguration() {
        return this.configuration;
    }

    /**
     * <p>
     * Associates a <code>TagKey</code> configuration to an account.
     * </p>
     * 
     * @param configuration
     *        Associates a <code>TagKey</code> configuration to an account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutConfigurationRequest withConfiguration(AppRegistryConfiguration configuration) {
        setConfiguration(configuration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getConfiguration() != null)
            sb.append("Configuration: ").append(getConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutConfigurationRequest == false)
            return false;
        PutConfigurationRequest other = (PutConfigurationRequest) obj;
        if (other.getConfiguration() == null ^ this.getConfiguration() == null)
            return false;
        if (other.getConfiguration() != null && other.getConfiguration().equals(this.getConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getConfiguration() == null) ? 0 : getConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public PutConfigurationRequest clone() {
        return (PutConfigurationRequest) super.clone();
    }

}
