/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appmesh.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.appmesh.model.MeshRef;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListMeshesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<MeshRef> meshes;
    private String nextToken;

    public List<MeshRef> getMeshes() {
        return this.meshes;
    }

    public void setMeshes(Collection<MeshRef> meshes) {
        if (meshes == null) {
            this.meshes = null;
            return;
        }
        this.meshes = new ArrayList<MeshRef>(meshes);
    }

    public ListMeshesResult withMeshes(MeshRef ... meshes) {
        if (this.meshes == null) {
            this.setMeshes(new ArrayList<MeshRef>(meshes.length));
        }
        for (MeshRef ele : meshes) {
            this.meshes.add(ele);
        }
        return this;
    }

    public ListMeshesResult withMeshes(Collection<MeshRef> meshes) {
        this.setMeshes(meshes);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListMeshesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMeshes() != null) {
            sb.append("Meshes: ").append(this.getMeshes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMeshesResult)) {
            return false;
        }
        ListMeshesResult other = (ListMeshesResult)obj;
        if (other.getMeshes() == null ^ this.getMeshes() == null) {
            return false;
        }
        if (other.getMeshes() != null && !other.getMeshes().equals(this.getMeshes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMeshes() == null ? 0 : this.getMeshes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListMeshesResult clone() {
        try {
            return (ListMeshesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

