/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationautoscaling.model.Alarm;
import com.amazonaws.services.applicationautoscaling.model.PolicyType;
import com.amazonaws.services.applicationautoscaling.model.ScalableDimension;
import com.amazonaws.services.applicationautoscaling.model.ServiceNamespace;
import com.amazonaws.services.applicationautoscaling.model.StepScalingPolicyConfiguration;
import com.amazonaws.services.applicationautoscaling.model.transform.ScalingPolicyMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ScalingPolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private String policyARN;
    private String policyName;
    private String serviceNamespace;
    private String resourceId;
    private String scalableDimension;
    private String policyType;
    private StepScalingPolicyConfiguration stepScalingPolicyConfiguration;
    private List<Alarm> alarms;
    private Date creationTime;

    public void setPolicyARN(String policyARN) {
        this.policyARN = policyARN;
    }

    public String getPolicyARN() {
        return this.policyARN;
    }

    public ScalingPolicy withPolicyARN(String policyARN) {
        this.setPolicyARN(policyARN);
        return this;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public ScalingPolicy withPolicyName(String policyName) {
        this.setPolicyName(policyName);
        return this;
    }

    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public ScalingPolicy withServiceNamespace(String serviceNamespace) {
        this.setServiceNamespace(serviceNamespace);
        return this;
    }

    @JsonIgnore
    public void setServiceNamespace(ServiceNamespace serviceNamespace) {
        this.serviceNamespace = serviceNamespace.toString();
    }

    public ScalingPolicy withServiceNamespace(ServiceNamespace serviceNamespace) {
        this.setServiceNamespace(serviceNamespace);
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ScalingPolicy withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setScalableDimension(String scalableDimension) {
        this.scalableDimension = scalableDimension;
    }

    public String getScalableDimension() {
        return this.scalableDimension;
    }

    public ScalingPolicy withScalableDimension(String scalableDimension) {
        this.setScalableDimension(scalableDimension);
        return this;
    }

    @JsonIgnore
    public void setScalableDimension(ScalableDimension scalableDimension) {
        this.scalableDimension = scalableDimension.toString();
    }

    public ScalingPolicy withScalableDimension(ScalableDimension scalableDimension) {
        this.setScalableDimension(scalableDimension);
        return this;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public ScalingPolicy withPolicyType(String policyType) {
        this.setPolicyType(policyType);
        return this;
    }

    @JsonIgnore
    public void setPolicyType(PolicyType policyType) {
        this.policyType = policyType.toString();
    }

    public ScalingPolicy withPolicyType(PolicyType policyType) {
        this.setPolicyType(policyType);
        return this;
    }

    public void setStepScalingPolicyConfiguration(StepScalingPolicyConfiguration stepScalingPolicyConfiguration) {
        this.stepScalingPolicyConfiguration = stepScalingPolicyConfiguration;
    }

    public StepScalingPolicyConfiguration getStepScalingPolicyConfiguration() {
        return this.stepScalingPolicyConfiguration;
    }

    public ScalingPolicy withStepScalingPolicyConfiguration(StepScalingPolicyConfiguration stepScalingPolicyConfiguration) {
        this.setStepScalingPolicyConfiguration(stepScalingPolicyConfiguration);
        return this;
    }

    public List<Alarm> getAlarms() {
        return this.alarms;
    }

    public void setAlarms(Collection<Alarm> alarms) {
        if (alarms == null) {
            this.alarms = null;
            return;
        }
        this.alarms = new ArrayList<Alarm>(alarms);
    }

    public ScalingPolicy withAlarms(Alarm ... alarms) {
        if (this.alarms == null) {
            this.setAlarms(new ArrayList<Alarm>(alarms.length));
        }
        for (Alarm ele : alarms) {
            this.alarms.add(ele);
        }
        return this;
    }

    public ScalingPolicy withAlarms(Collection<Alarm> alarms) {
        this.setAlarms(alarms);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public ScalingPolicy withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyARN() != null) {
            sb.append("PolicyARN: ").append(this.getPolicyARN()).append(",");
        }
        if (this.getPolicyName() != null) {
            sb.append("PolicyName: ").append(this.getPolicyName()).append(",");
        }
        if (this.getServiceNamespace() != null) {
            sb.append("ServiceNamespace: ").append(this.getServiceNamespace()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getScalableDimension() != null) {
            sb.append("ScalableDimension: ").append(this.getScalableDimension()).append(",");
        }
        if (this.getPolicyType() != null) {
            sb.append("PolicyType: ").append(this.getPolicyType()).append(",");
        }
        if (this.getStepScalingPolicyConfiguration() != null) {
            sb.append("StepScalingPolicyConfiguration: ").append(this.getStepScalingPolicyConfiguration()).append(",");
        }
        if (this.getAlarms() != null) {
            sb.append("Alarms: ").append(this.getAlarms()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        if (other.getPolicyARN() == null ^ this.getPolicyARN() == null) {
            return false;
        }
        if (other.getPolicyARN() != null && !other.getPolicyARN().equals(this.getPolicyARN())) {
            return false;
        }
        if (other.getPolicyName() == null ^ this.getPolicyName() == null) {
            return false;
        }
        if (other.getPolicyName() != null && !other.getPolicyName().equals(this.getPolicyName())) {
            return false;
        }
        if (other.getServiceNamespace() == null ^ this.getServiceNamespace() == null) {
            return false;
        }
        if (other.getServiceNamespace() != null && !other.getServiceNamespace().equals(this.getServiceNamespace())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getScalableDimension() == null ^ this.getScalableDimension() == null) {
            return false;
        }
        if (other.getScalableDimension() != null && !other.getScalableDimension().equals(this.getScalableDimension())) {
            return false;
        }
        if (other.getPolicyType() == null ^ this.getPolicyType() == null) {
            return false;
        }
        if (other.getPolicyType() != null && !other.getPolicyType().equals(this.getPolicyType())) {
            return false;
        }
        if (other.getStepScalingPolicyConfiguration() == null ^ this.getStepScalingPolicyConfiguration() == null) {
            return false;
        }
        if (other.getStepScalingPolicyConfiguration() != null && !other.getStepScalingPolicyConfiguration().equals(this.getStepScalingPolicyConfiguration())) {
            return false;
        }
        if (other.getAlarms() == null ^ this.getAlarms() == null) {
            return false;
        }
        if (other.getAlarms() != null && !other.getAlarms().equals(this.getAlarms())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        return other.getCreationTime() == null || other.getCreationTime().equals(this.getCreationTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyARN() == null ? 0 : this.getPolicyARN().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyName() == null ? 0 : this.getPolicyName().hashCode());
        hashCode = 31 * hashCode + (this.getServiceNamespace() == null ? 0 : this.getServiceNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getScalableDimension() == null ? 0 : this.getScalableDimension().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyType() == null ? 0 : this.getPolicyType().hashCode());
        hashCode = 31 * hashCode + (this.getStepScalingPolicyConfiguration() == null ? 0 : this.getStepScalingPolicyConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAlarms() == null ? 0 : this.getAlarms().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        return hashCode;
    }

    public ScalingPolicy clone() {
        try {
            return (ScalingPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

