/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.services.appflow.model.AuthenticationConfig;
import com.amazonaws.services.appflow.model.transform.CustomAuthConfigJsonUnmarshaller;
import com.amazonaws.services.appflow.model.transform.OAuth2DefaultsJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class AuthenticationConfigJsonUnmarshaller
implements Unmarshaller<AuthenticationConfig, JsonUnmarshallerContext> {
    private static AuthenticationConfigJsonUnmarshaller instance;

    public AuthenticationConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        AuthenticationConfig authenticationConfig = new AuthenticationConfig();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("isBasicAuthSupported", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    authenticationConfig.setIsBasicAuthSupported((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("isApiKeyAuthSupported", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    authenticationConfig.setIsApiKeyAuthSupported((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("isOAuth2Supported", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    authenticationConfig.setIsOAuth2Supported((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("isCustomAuthSupported", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    authenticationConfig.setIsCustomAuthSupported((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("oAuth2Defaults", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    authenticationConfig.setOAuth2Defaults(OAuth2DefaultsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("customAuthConfigs", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    authenticationConfig.setCustomAuthConfigs(new ListUnmarshaller((Unmarshaller)CustomAuthConfigJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return authenticationConfig;
    }

    public static AuthenticationConfigJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AuthenticationConfigJsonUnmarshaller();
        }
        return instance;
    }
}

