/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appflow.model.DestinationFlowConfig;
import com.amazonaws.services.appflow.model.SourceFlowConfig;
import com.amazonaws.services.appflow.model.Task;
import com.amazonaws.services.appflow.model.TriggerConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateFlowRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String flowName;
    private String description;
    private TriggerConfig triggerConfig;
    private SourceFlowConfig sourceFlowConfig;
    private List<DestinationFlowConfig> destinationFlowConfigList;
    private List<Task> tasks;

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public UpdateFlowRequest withFlowName(String flowName) {
        this.setFlowName(flowName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateFlowRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setTriggerConfig(TriggerConfig triggerConfig) {
        this.triggerConfig = triggerConfig;
    }

    public TriggerConfig getTriggerConfig() {
        return this.triggerConfig;
    }

    public UpdateFlowRequest withTriggerConfig(TriggerConfig triggerConfig) {
        this.setTriggerConfig(triggerConfig);
        return this;
    }

    public void setSourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
        this.sourceFlowConfig = sourceFlowConfig;
    }

    public SourceFlowConfig getSourceFlowConfig() {
        return this.sourceFlowConfig;
    }

    public UpdateFlowRequest withSourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
        this.setSourceFlowConfig(sourceFlowConfig);
        return this;
    }

    public List<DestinationFlowConfig> getDestinationFlowConfigList() {
        return this.destinationFlowConfigList;
    }

    public void setDestinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList) {
        if (destinationFlowConfigList == null) {
            this.destinationFlowConfigList = null;
            return;
        }
        this.destinationFlowConfigList = new ArrayList<DestinationFlowConfig>(destinationFlowConfigList);
    }

    public UpdateFlowRequest withDestinationFlowConfigList(DestinationFlowConfig ... destinationFlowConfigList) {
        if (this.destinationFlowConfigList == null) {
            this.setDestinationFlowConfigList(new ArrayList<DestinationFlowConfig>(destinationFlowConfigList.length));
        }
        for (DestinationFlowConfig ele : destinationFlowConfigList) {
            this.destinationFlowConfigList.add(ele);
        }
        return this;
    }

    public UpdateFlowRequest withDestinationFlowConfigList(Collection<DestinationFlowConfig> destinationFlowConfigList) {
        this.setDestinationFlowConfigList(destinationFlowConfigList);
        return this;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(Collection<Task> tasks) {
        if (tasks == null) {
            this.tasks = null;
            return;
        }
        this.tasks = new ArrayList<Task>(tasks);
    }

    public UpdateFlowRequest withTasks(Task ... tasks) {
        if (this.tasks == null) {
            this.setTasks(new ArrayList<Task>(tasks.length));
        }
        for (Task ele : tasks) {
            this.tasks.add(ele);
        }
        return this;
    }

    public UpdateFlowRequest withTasks(Collection<Task> tasks) {
        this.setTasks(tasks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFlowName() != null) {
            sb.append("FlowName: ").append(this.getFlowName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTriggerConfig() != null) {
            sb.append("TriggerConfig: ").append(this.getTriggerConfig()).append(",");
        }
        if (this.getSourceFlowConfig() != null) {
            sb.append("SourceFlowConfig: ").append(this.getSourceFlowConfig()).append(",");
        }
        if (this.getDestinationFlowConfigList() != null) {
            sb.append("DestinationFlowConfigList: ").append(this.getDestinationFlowConfigList()).append(",");
        }
        if (this.getTasks() != null) {
            sb.append("Tasks: ").append(this.getTasks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowRequest)) {
            return false;
        }
        UpdateFlowRequest other = (UpdateFlowRequest)obj;
        if (other.getFlowName() == null ^ this.getFlowName() == null) {
            return false;
        }
        if (other.getFlowName() != null && !other.getFlowName().equals(this.getFlowName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTriggerConfig() == null ^ this.getTriggerConfig() == null) {
            return false;
        }
        if (other.getTriggerConfig() != null && !other.getTriggerConfig().equals(this.getTriggerConfig())) {
            return false;
        }
        if (other.getSourceFlowConfig() == null ^ this.getSourceFlowConfig() == null) {
            return false;
        }
        if (other.getSourceFlowConfig() != null && !other.getSourceFlowConfig().equals(this.getSourceFlowConfig())) {
            return false;
        }
        if (other.getDestinationFlowConfigList() == null ^ this.getDestinationFlowConfigList() == null) {
            return false;
        }
        if (other.getDestinationFlowConfigList() != null && !other.getDestinationFlowConfigList().equals(this.getDestinationFlowConfigList())) {
            return false;
        }
        if (other.getTasks() == null ^ this.getTasks() == null) {
            return false;
        }
        return other.getTasks() == null || other.getTasks().equals(this.getTasks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFlowName() == null ? 0 : this.getFlowName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerConfig() == null ? 0 : this.getTriggerConfig().hashCode());
        hashCode = 31 * hashCode + (this.getSourceFlowConfig() == null ? 0 : this.getSourceFlowConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationFlowConfigList() == null ? 0 : this.getDestinationFlowConfigList().hashCode());
        hashCode = 31 * hashCode + (this.getTasks() == null ? 0 : this.getTasks().hashCode());
        return hashCode;
    }

    public UpdateFlowRequest clone() {
        return (UpdateFlowRequest)super.clone();
    }
}

