/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appfabric.model.DestinationConfiguration;
import com.amazonaws.services.appfabric.model.ProcessingConfiguration;
import com.amazonaws.services.appfabric.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateIngestionDestinationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String appBundleIdentifier;
    private String ingestionIdentifier;
    private ProcessingConfiguration processingConfiguration;
    private DestinationConfiguration destinationConfiguration;
    private String clientToken;
    private List<Tag> tags;

    public void setAppBundleIdentifier(String appBundleIdentifier) {
        this.appBundleIdentifier = appBundleIdentifier;
    }

    public String getAppBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    public CreateIngestionDestinationRequest withAppBundleIdentifier(String appBundleIdentifier) {
        this.setAppBundleIdentifier(appBundleIdentifier);
        return this;
    }

    public void setIngestionIdentifier(String ingestionIdentifier) {
        this.ingestionIdentifier = ingestionIdentifier;
    }

    public String getIngestionIdentifier() {
        return this.ingestionIdentifier;
    }

    public CreateIngestionDestinationRequest withIngestionIdentifier(String ingestionIdentifier) {
        this.setIngestionIdentifier(ingestionIdentifier);
        return this;
    }

    public void setProcessingConfiguration(ProcessingConfiguration processingConfiguration) {
        this.processingConfiguration = processingConfiguration;
    }

    public ProcessingConfiguration getProcessingConfiguration() {
        return this.processingConfiguration;
    }

    public CreateIngestionDestinationRequest withProcessingConfiguration(ProcessingConfiguration processingConfiguration) {
        this.setProcessingConfiguration(processingConfiguration);
        return this;
    }

    public void setDestinationConfiguration(DestinationConfiguration destinationConfiguration) {
        this.destinationConfiguration = destinationConfiguration;
    }

    public DestinationConfiguration getDestinationConfiguration() {
        return this.destinationConfiguration;
    }

    public CreateIngestionDestinationRequest withDestinationConfiguration(DestinationConfiguration destinationConfiguration) {
        this.setDestinationConfiguration(destinationConfiguration);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateIngestionDestinationRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateIngestionDestinationRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateIngestionDestinationRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppBundleIdentifier() != null) {
            sb.append("AppBundleIdentifier: ").append(this.getAppBundleIdentifier()).append(",");
        }
        if (this.getIngestionIdentifier() != null) {
            sb.append("IngestionIdentifier: ").append(this.getIngestionIdentifier()).append(",");
        }
        if (this.getProcessingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(this.getProcessingConfiguration()).append(",");
        }
        if (this.getDestinationConfiguration() != null) {
            sb.append("DestinationConfiguration: ").append(this.getDestinationConfiguration()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngestionDestinationRequest)) {
            return false;
        }
        CreateIngestionDestinationRequest other = (CreateIngestionDestinationRequest)obj;
        if (other.getAppBundleIdentifier() == null ^ this.getAppBundleIdentifier() == null) {
            return false;
        }
        if (other.getAppBundleIdentifier() != null && !other.getAppBundleIdentifier().equals(this.getAppBundleIdentifier())) {
            return false;
        }
        if (other.getIngestionIdentifier() == null ^ this.getIngestionIdentifier() == null) {
            return false;
        }
        if (other.getIngestionIdentifier() != null && !other.getIngestionIdentifier().equals(this.getIngestionIdentifier())) {
            return false;
        }
        if (other.getProcessingConfiguration() == null ^ this.getProcessingConfiguration() == null) {
            return false;
        }
        if (other.getProcessingConfiguration() != null && !other.getProcessingConfiguration().equals(this.getProcessingConfiguration())) {
            return false;
        }
        if (other.getDestinationConfiguration() == null ^ this.getDestinationConfiguration() == null) {
            return false;
        }
        if (other.getDestinationConfiguration() != null && !other.getDestinationConfiguration().equals(this.getDestinationConfiguration())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppBundleIdentifier() == null ? 0 : this.getAppBundleIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getIngestionIdentifier() == null ? 0 : this.getIngestionIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getProcessingConfiguration() == null ? 0 : this.getProcessingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationConfiguration() == null ? 0 : this.getDestinationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateIngestionDestinationRequest clone() {
        return (CreateIngestionDestinationRequest)super.clone();
    }
}

