/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetModelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetModelRequestMarshaller
implements Marshaller<Request<GetModelRequest>, GetModelRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public GetModelRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetModelRequest> marshall(GetModelRequest getModelRequest) {
        if (getModelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getModelRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/models/{model_name}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getModelRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getModelRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{model_name}", getModelRequest.getModelName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getModelRequest.getModelName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (getModelRequest.getFlatten() != null) {
            request.addParameter("flatten", StringUtils.fromBoolean((Boolean)getModelRequest.getFlatten()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

