/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetBasePathMappingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetBasePathMappingsRequestMarshaller
implements Marshaller<Request<GetBasePathMappingsRequest>, GetBasePathMappingsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetBasePathMappingsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetBasePathMappingsRequest> marshall(GetBasePathMappingsRequest getBasePathMappingsRequest) {
        if (getBasePathMappingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getBasePathMappingsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings";
        uriResourcePath = uriResourcePath.replace("{domain_name}", getBasePathMappingsRequest.getDomainName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getBasePathMappingsRequest.getDomainName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (getBasePathMappingsRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString((String)getBasePathMappingsRequest.getPosition()));
        }
        if (getBasePathMappingsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger((Integer)getBasePathMappingsRequest.getLimit()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

