/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateBasePathMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateBasePathMappingRequestMarshaller
implements Marshaller<Request<CreateBasePathMappingRequest>, CreateBasePathMappingRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateBasePathMappingRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateBasePathMappingRequest> marshall(CreateBasePathMappingRequest createBasePathMappingRequest) {
        if (createBasePathMappingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createBasePathMappingRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings";
        uriResourcePath = uriResourcePath.replace("{domain_name}", createBasePathMappingRequest.getDomainName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)createBasePathMappingRequest.getDomainName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createBasePathMappingRequest.getBasePath() != null) {
                jsonGenerator.writeFieldName("basePath").writeValue(createBasePathMappingRequest.getBasePath());
            }
            if (createBasePathMappingRequest.getRestApiId() != null) {
                jsonGenerator.writeFieldName("restApiId").writeValue(createBasePathMappingRequest.getRestApiId());
            }
            if (createBasePathMappingRequest.getStage() != null) {
                jsonGenerator.writeFieldName("stage").writeValue(createBasePathMappingRequest.getStage());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

