/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.ApiStage;
import com.amazonaws.services.apigateway.model.CreateUsagePlanRequest;
import com.amazonaws.services.apigateway.model.transform.ApiStageJsonMarshaller;
import com.amazonaws.services.apigateway.model.transform.QuotaSettingsJsonMarshaller;
import com.amazonaws.services.apigateway.model.transform.ThrottleSettingsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class CreateUsagePlanRequestMarshaller
implements Marshaller<Request<CreateUsagePlanRequest>, CreateUsagePlanRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateUsagePlanRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateUsagePlanRequest> marshall(CreateUsagePlanRequest createUsagePlanRequest) {
        if (createUsagePlanRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUsagePlanRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/usageplans";
        request.setResourcePath(uriResourcePath);
        try {
            List<ApiStage> apiStagesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createUsagePlanRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createUsagePlanRequest.getName());
            }
            if (createUsagePlanRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createUsagePlanRequest.getDescription());
            }
            if ((apiStagesList = createUsagePlanRequest.getApiStages()) != null) {
                jsonGenerator.writeFieldName("apiStages");
                jsonGenerator.writeStartArray();
                for (ApiStage apiStagesListValue : apiStagesList) {
                    if (apiStagesListValue == null) continue;
                    ApiStageJsonMarshaller.getInstance().marshall(apiStagesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createUsagePlanRequest.getThrottle() != null) {
                jsonGenerator.writeFieldName("throttle");
                ThrottleSettingsJsonMarshaller.getInstance().marshall(createUsagePlanRequest.getThrottle(), jsonGenerator);
            }
            if (createUsagePlanRequest.getQuota() != null) {
                jsonGenerator.writeFieldName("quota");
                QuotaSettingsJsonMarshaller.getInstance().marshall(createUsagePlanRequest.getQuota(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

