/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetDeploymentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetDeploymentsRequestMarshaller
implements Marshaller<Request<GetDeploymentsRequest>, GetDeploymentsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetDeploymentsRequest> marshall(GetDeploymentsRequest getDeploymentsRequest) {
        if (getDeploymentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getDeploymentsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/deployments";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getDeploymentsRequest.getRestApiId() != null ? StringUtils.fromString((String)getDeploymentsRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (getDeploymentsRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString((String)getDeploymentsRequest.getPosition()));
        }
        if (getDeploymentsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger((Integer)getDeploymentsRequest.getLimit()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

