/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.Deployment;
import com.amazonaws.services.apigateway.model.MethodSnapshot;
import com.amazonaws.services.apigateway.model.transform.MethodSnapshotJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.Map;

public class DeploymentJsonMarshaller {
    private static DeploymentJsonMarshaller instance;

    public void marshall(Deployment deployment, StructuredJsonGenerator jsonGenerator) {
        if (deployment == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Map<String, MethodSnapshot>> apiSummaryMap;
            jsonGenerator.writeStartObject();
            if (deployment.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(deployment.getId());
            }
            if (deployment.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(deployment.getDescription());
            }
            if (deployment.getCreatedDate() != null) {
                jsonGenerator.writeFieldName("createdDate").writeValue(deployment.getCreatedDate());
            }
            if ((apiSummaryMap = deployment.getApiSummary()) != null) {
                jsonGenerator.writeFieldName("apiSummary");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Map<String, MethodSnapshot>> apiSummaryMapValue : apiSummaryMap.entrySet()) {
                    if (apiSummaryMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(apiSummaryMapValue.getKey());
                    jsonGenerator.writeStartObject();
                    for (Map.Entry<String, MethodSnapshot> apiSummaryMapValueNestedMap : apiSummaryMapValue.getValue().entrySet()) {
                        if (apiSummaryMapValueNestedMap.getValue() == null) continue;
                        jsonGenerator.writeFieldName(apiSummaryMapValueNestedMap.getKey());
                        MethodSnapshotJsonMarshaller.getInstance().marshall(apiSummaryMapValueNestedMap.getValue(), jsonGenerator);
                    }
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentJsonMarshaller();
        }
        return instance;
    }
}

