/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PatchOperation;
import com.amazonaws.services.apigateway.model.UpdateIntegrationResponseRequest;
import com.amazonaws.services.apigateway.model.transform.PatchOperationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateIntegrationResponseRequestMarshaller
implements Marshaller<Request<UpdateIntegrationResponseRequest>, UpdateIntegrationResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<UpdateIntegrationResponseRequest> marshall(UpdateIntegrationResponseRequest updateIntegrationResponseRequest) {
        if (updateIntegrationResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateIntegrationResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", updateIntegrationResponseRequest.getRestApiId() != null ? StringUtils.fromString((String)updateIntegrationResponseRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{resource_id}", updateIntegrationResponseRequest.getResourceId() != null ? StringUtils.fromString((String)updateIntegrationResponseRequest.getResourceId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{http_method}", updateIntegrationResponseRequest.getHttpMethod() != null ? StringUtils.fromString((String)updateIntegrationResponseRequest.getHttpMethod()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{status_code}", updateIntegrationResponseRequest.getStatusCode() != null ? StringUtils.fromString((String)updateIntegrationResponseRequest.getStatusCode()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            List<PatchOperation> patchOperationsList = updateIntegrationResponseRequest.getPatchOperations();
            if (patchOperationsList != null) {
                jsonGenerator.writeFieldName("patchOperations");
                jsonGenerator.writeStartArray();
                for (PatchOperation patchOperationsListValue : patchOperationsList) {
                    if (patchOperationsListValue == null) continue;
                    PatchOperationJsonMarshaller.getInstance().marshall(patchOperationsListValue, (StructuredJsonGenerator)jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

