/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.TestInvokeMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class TestInvokeMethodRequestMarshaller
implements Marshaller<Request<TestInvokeMethodRequest>, TestInvokeMethodRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<TestInvokeMethodRequest> marshall(TestInvokeMethodRequest testInvokeMethodRequest) {
        if (testInvokeMethodRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testInvokeMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", testInvokeMethodRequest.getRestApiId() != null ? StringUtils.fromString((String)testInvokeMethodRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{resource_id}", testInvokeMethodRequest.getResourceId() != null ? StringUtils.fromString((String)testInvokeMethodRequest.getResourceId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{http_method}", testInvokeMethodRequest.getHttpMethod() != null ? StringUtils.fromString((String)testInvokeMethodRequest.getHttpMethod()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> stageVariablesMap;
            Map<String, String> headersMap;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (testInvokeMethodRequest.getPathWithQueryString() != null) {
                jsonGenerator.writeFieldName("pathWithQueryString").writeValue(testInvokeMethodRequest.getPathWithQueryString());
            }
            if (testInvokeMethodRequest.getBody() != null) {
                jsonGenerator.writeFieldName("body").writeValue(testInvokeMethodRequest.getBody());
            }
            if ((headersMap = testInvokeMethodRequest.getHeaders()) != null) {
                jsonGenerator.writeFieldName("headers");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> headersMapValue : headersMap.entrySet()) {
                    if (headersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)headersMapValue.getKey());
                    jsonGenerator.writeValue((String)headersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (testInvokeMethodRequest.getClientCertificateId() != null) {
                jsonGenerator.writeFieldName("clientCertificateId").writeValue(testInvokeMethodRequest.getClientCertificateId());
            }
            if ((stageVariablesMap = testInvokeMethodRequest.getStageVariables()) != null) {
                jsonGenerator.writeFieldName("stageVariables");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : stageVariablesMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

