/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.Authorizer;
import com.amazonaws.util.json.SdkJsonGenerator;

public class AuthorizerJsonMarshaller {
    private static AuthorizerJsonMarshaller instance;

    public void marshall(Authorizer authorizer, SdkJsonGenerator jsonGenerator) {
        if (authorizer == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (authorizer.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(authorizer.getId());
            }
            if (authorizer.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(authorizer.getName());
            }
            if (authorizer.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(authorizer.getType());
            }
            if (authorizer.getAuthorizerUri() != null) {
                jsonGenerator.writeFieldName("authorizerUri").writeValue(authorizer.getAuthorizerUri());
            }
            if (authorizer.getAuthorizerCredentials() != null) {
                jsonGenerator.writeFieldName("authorizerCredentials").writeValue(authorizer.getAuthorizerCredentials());
            }
            if (authorizer.getIdentitySource() != null) {
                jsonGenerator.writeFieldName("identitySource").writeValue(authorizer.getIdentitySource());
            }
            if (authorizer.getIdentityValidationExpression() != null) {
                jsonGenerator.writeFieldName("identityValidationExpression").writeValue(authorizer.getIdentityValidationExpression());
            }
            if (authorizer.getAuthorizerResultTtlInSeconds() != null) {
                jsonGenerator.writeFieldName("authorizerResultTtlInSeconds").writeValue((long)authorizer.getAuthorizerResultTtlInSeconds().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AuthorizerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AuthorizerJsonMarshaller();
        }
        return instance;
    }
}

