/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.TestInvokeMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class TestInvokeMethodRequestMarshaller
implements Marshaller<Request<TestInvokeMethodRequest>, TestInvokeMethodRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<TestInvokeMethodRequest> marshall(TestInvokeMethodRequest testInvokeMethodRequest) {
        if (testInvokeMethodRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testInvokeMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", testInvokeMethodRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)testInvokeMethodRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", testInvokeMethodRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)testInvokeMethodRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", testInvokeMethodRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)testInvokeMethodRequest.getHttpMethod()));
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> stageVariablesMap;
            Map<String, String> headersMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (testInvokeMethodRequest.getPathWithQueryString() != null) {
                jsonWriter.key("pathWithQueryString").value((Object)testInvokeMethodRequest.getPathWithQueryString());
            }
            if (testInvokeMethodRequest.getBody() != null) {
                jsonWriter.key("body").value((Object)testInvokeMethodRequest.getBody());
            }
            if ((headersMap = testInvokeMethodRequest.getHeaders()) != null) {
                jsonWriter.key("headers");
                jsonWriter.object();
                for (Map.Entry<String, String> headersMapValue : headersMap.entrySet()) {
                    if (headersMapValue.getValue() == null) continue;
                    jsonWriter.key(headersMapValue.getKey());
                    jsonWriter.value((Object)headersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (testInvokeMethodRequest.getClientCertificateId() != null) {
                jsonWriter.key("clientCertificateId").value((Object)testInvokeMethodRequest.getClientCertificateId());
            }
            if ((stageVariablesMap = testInvokeMethodRequest.getStageVariables()) != null) {
                jsonWriter.key("stageVariables");
                jsonWriter.object();
                for (Map.Entry<String, String> stageVariablesMapValue : stageVariablesMap.entrySet()) {
                    if (stageVariablesMapValue.getValue() == null) continue;
                    jsonWriter.key(stageVariablesMapValue.getKey());
                    jsonWriter.value((Object)stageVariablesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

