/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetResourcesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetResourcesRequestMarshaller
implements Marshaller<Request<GetResourcesRequest>, GetResourcesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetResourcesRequest> marshall(GetResourcesRequest getResourcesRequest) {
        String limit;
        String position;
        if (getResourcesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getResourcesRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getResourcesRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getResourcesRequest.getRestApiId()));
        request.setResourcePath(uriResourcePath);
        String string = position = getResourcesRequest.getPosition() == null ? null : StringUtils.fromString((String)getResourcesRequest.getPosition());
        if (position != null) {
            request.addParameter("position", position);
        }
        String string2 = limit = getResourcesRequest.getLimit() == null ? null : StringUtils.fromInteger((Integer)getResourcesRequest.getLimit());
        if (limit != null) {
            request.addParameter("limit", limit);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

