/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetMethodRequestMarshaller
implements Marshaller<Request<GetMethodRequest>, GetMethodRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetMethodRequest> marshall(GetMethodRequest getMethodRequest) {
        if (getMethodRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getMethodRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getMethodRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", getMethodRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getMethodRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", getMethodRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getMethodRequest.getHttpMethod()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

