/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetDeploymentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetDeploymentsRequestMarshaller
implements Marshaller<Request<GetDeploymentsRequest>, GetDeploymentsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetDeploymentsRequest> marshall(GetDeploymentsRequest getDeploymentsRequest) {
        String limit;
        String position;
        if (getDeploymentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getDeploymentsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/deployments";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getDeploymentsRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getDeploymentsRequest.getRestApiId()));
        request.setResourcePath(uriResourcePath);
        String string = position = getDeploymentsRequest.getPosition() == null ? null : StringUtils.fromString((String)getDeploymentsRequest.getPosition());
        if (position != null) {
            request.addParameter("position", position);
        }
        String string2 = limit = getDeploymentsRequest.getLimit() == null ? null : StringUtils.fromInteger((Integer)getDeploymentsRequest.getLimit());
        if (limit != null) {
            request.addParameter("limit", limit);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

