/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetModelsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetModelsRequestMarshaller
implements Marshaller<Request<GetModelsRequest>, GetModelsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetModelsRequest> marshall(GetModelsRequest getModelsRequest) {
        String limit;
        String position;
        if (getModelsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getModelsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/models";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getModelsRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getModelsRequest.getRestApiId()));
        request.setResourcePath(uriResourcePath);
        String string = position = getModelsRequest.getPosition() == null ? null : StringUtils.fromString((String)getModelsRequest.getPosition());
        if (position != null) {
            request.addParameter("position", position);
        }
        String string2 = limit = getModelsRequest.getLimit() == null ? null : StringUtils.fromInteger((Integer)getModelsRequest.getLimit());
        if (limit != null) {
            request.addParameter("limit", limit);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

