/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetMethodResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetMethodResponseRequestMarshaller
implements Marshaller<Request<GetMethodResponseRequest>, GetMethodResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetMethodResponseRequest> marshall(GetMethodResponseRequest getMethodResponseRequest) {
        if (getMethodResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getMethodResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getMethodResponseRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getMethodResponseRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", getMethodResponseRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getMethodResponseRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", getMethodResponseRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getMethodResponseRequest.getHttpMethod()));
        uriResourcePath = uriResourcePath.replace("{status_code}", getMethodResponseRequest.getStatusCode() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getMethodResponseRequest.getStatusCode()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

