/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetModelTemplateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetModelTemplateRequestMarshaller
implements Marshaller<Request<GetModelTemplateRequest>, GetModelTemplateRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetModelTemplateRequest> marshall(GetModelTemplateRequest getModelTemplateRequest) {
        if (getModelTemplateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getModelTemplateRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/models/{model_name}/default_template";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getModelTemplateRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getModelTemplateRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{model_name}", getModelTemplateRequest.getModelName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getModelTemplateRequest.getModelName()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

