/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PutIntegrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class PutIntegrationRequestMarshaller
implements Marshaller<Request<PutIntegrationRequest>, PutIntegrationRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<PutIntegrationRequest> marshall(PutIntegrationRequest putIntegrationRequest) {
        if (putIntegrationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putIntegrationRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putIntegrationRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)putIntegrationRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", putIntegrationRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)putIntegrationRequest.getResourceId()));
        request.setResourcePath(uriResourcePath);
        try {
            List<String> cacheKeyParametersList;
            Map<String, String> requestTemplatesMap;
            Map<String, String> requestParametersMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (putIntegrationRequest.getHttpMethod() != null) {
                jsonWriter.key("httpMethod").value((Object)putIntegrationRequest.getHttpMethod());
            }
            if (putIntegrationRequest.getType() != null) {
                jsonWriter.key("type").value((Object)putIntegrationRequest.getType());
            }
            if (putIntegrationRequest.getUri() != null) {
                jsonWriter.key("uri").value((Object)putIntegrationRequest.getUri());
            }
            if (putIntegrationRequest.getCredentials() != null) {
                jsonWriter.key("credentials").value((Object)putIntegrationRequest.getCredentials());
            }
            if ((requestParametersMap = putIntegrationRequest.getRequestParameters()) != null) {
                jsonWriter.key("requestParameters");
                jsonWriter.object();
                for (Map.Entry<String, String> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonWriter.key(requestParametersMapValue.getKey());
                    jsonWriter.value((Object)requestParametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((requestTemplatesMap = putIntegrationRequest.getRequestTemplates()) != null) {
                jsonWriter.key("requestTemplates");
                jsonWriter.object();
                for (Map.Entry<String, String> requestTemplatesMapValue : requestTemplatesMap.entrySet()) {
                    if (requestTemplatesMapValue.getValue() == null) continue;
                    jsonWriter.key(requestTemplatesMapValue.getKey());
                    jsonWriter.value((Object)requestTemplatesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (putIntegrationRequest.getCacheNamespace() != null) {
                jsonWriter.key("cacheNamespace").value((Object)putIntegrationRequest.getCacheNamespace());
            }
            if ((cacheKeyParametersList = putIntegrationRequest.getCacheKeyParameters()) != null) {
                jsonWriter.key("cacheKeyParameters");
                jsonWriter.array();
                for (String cacheKeyParametersListValue : cacheKeyParametersList) {
                    if (cacheKeyParametersListValue == null) continue;
                    jsonWriter.value((Object)cacheKeyParametersListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

