/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.amplifyuibuilder.model.transform.ComponentVariantMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ComponentVariant
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, Map<String, String>> overrides;
    private Map<String, String> variantValues;

    public Map<String, Map<String, String>> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(Map<String, Map<String, String>> overrides) {
        this.overrides = overrides;
    }

    public ComponentVariant withOverrides(Map<String, Map<String, String>> overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public ComponentVariant addOverridesEntry(String key, Map<String, String> value) {
        if (null == this.overrides) {
            this.overrides = new HashMap<String, Map<String, String>>();
        }
        if (this.overrides.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.overrides.put(key, value);
        return this;
    }

    public ComponentVariant clearOverridesEntries() {
        this.overrides = null;
        return this;
    }

    public Map<String, String> getVariantValues() {
        return this.variantValues;
    }

    public void setVariantValues(Map<String, String> variantValues) {
        this.variantValues = variantValues;
    }

    public ComponentVariant withVariantValues(Map<String, String> variantValues) {
        this.setVariantValues(variantValues);
        return this;
    }

    public ComponentVariant addVariantValuesEntry(String key, String value) {
        if (null == this.variantValues) {
            this.variantValues = new HashMap<String, String>();
        }
        if (this.variantValues.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.variantValues.put(key, value);
        return this;
    }

    public ComponentVariant clearVariantValuesEntries() {
        this.variantValues = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOverrides() != null) {
            sb.append("Overrides: ").append(this.getOverrides()).append(",");
        }
        if (this.getVariantValues() != null) {
            sb.append("VariantValues: ").append(this.getVariantValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentVariant)) {
            return false;
        }
        ComponentVariant other = (ComponentVariant)obj;
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getVariantValues() == null ^ this.getVariantValues() == null) {
            return false;
        }
        return other.getVariantValues() == null || other.getVariantValues().equals(this.getVariantValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getVariantValues() == null ? 0 : this.getVariantValues().hashCode());
        return hashCode;
    }

    public ComponentVariant clone() {
        try {
            return (ComponentVariant)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentVariantMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

