/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.alexaforbusiness;

import javax.annotation.Generated;

import com.amazonaws.services.alexaforbusiness.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonAlexaForBusiness}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonAlexaForBusiness implements AmazonAlexaForBusiness {

    protected AbstractAmazonAlexaForBusiness() {
    }

    @Override
    public AssociateDeviceWithRoomResult associateDeviceWithRoom(AssociateDeviceWithRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateSkillGroupWithRoomResult associateSkillGroupWithRoom(AssociateSkillGroupWithRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProfileResult createProfile(CreateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRoomResult createRoom(CreateRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSkillGroupResult createSkillGroup(CreateSkillGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProfileResult deleteProfile(DeleteProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRoomResult deleteRoom(DeleteRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRoomSkillParameterResult deleteRoomSkillParameter(DeleteRoomSkillParameterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSkillGroupResult deleteSkillGroup(DeleteSkillGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateDeviceFromRoomResult disassociateDeviceFromRoom(DisassociateDeviceFromRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateSkillGroupFromRoomResult disassociateSkillGroupFromRoom(DisassociateSkillGroupFromRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeviceResult getDevice(GetDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProfileResult getProfile(GetProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRoomResult getRoom(GetRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRoomSkillParameterResult getRoomSkillParameter(GetRoomSkillParameterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSkillGroupResult getSkillGroup(GetSkillGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSkillsResult listSkills(ListSkillsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsResult listTags(ListTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutRoomSkillParameterResult putRoomSkillParameter(PutRoomSkillParameterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResolveRoomResult resolveRoom(ResolveRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RevokeInvitationResult revokeInvitation(RevokeInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchDevicesResult searchDevices(SearchDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchProfilesResult searchProfiles(SearchProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchRoomsResult searchRooms(SearchRoomsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchSkillGroupsResult searchSkillGroups(SearchSkillGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchUsersResult searchUsers(SearchUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendInvitationResult sendInvitation(SendInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDeviceSyncResult startDeviceSync(StartDeviceSyncRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDeviceResult updateDevice(UpdateDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProfileResult updateProfile(UpdateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRoomResult updateRoom(UpdateRoomRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSkillGroupResult updateSkillGroup(UpdateSkillGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
