/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.acmpca.model.ActionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreatePermissionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String certificateAuthorityArn;
    private String principal;
    private String sourceAccount;
    private List<String> actions;

    public void setCertificateAuthorityArn(String certificateAuthorityArn) {
        this.certificateAuthorityArn = certificateAuthorityArn;
    }

    public String getCertificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public CreatePermissionRequest withCertificateAuthorityArn(String certificateAuthorityArn) {
        this.setCertificateAuthorityArn(certificateAuthorityArn);
        return this;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public CreatePermissionRequest withPrincipal(String principal) {
        this.setPrincipal(principal);
        return this;
    }

    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public CreatePermissionRequest withSourceAccount(String sourceAccount) {
        this.setSourceAccount(sourceAccount);
        return this;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<String>(actions);
    }

    public CreatePermissionRequest withActions(String ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<String>(actions.length));
        }
        for (String ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public CreatePermissionRequest withActions(Collection<String> actions) {
        this.setActions(actions);
        return this;
    }

    public CreatePermissionRequest withActions(ActionType ... actions) {
        ArrayList<String> actionsCopy = new ArrayList<String>(actions.length);
        for (ActionType value : actions) {
            actionsCopy.add(value.toString());
        }
        if (this.getActions() == null) {
            this.setActions(actionsCopy);
        } else {
            this.getActions().addAll(actionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateAuthorityArn() != null) {
            sb.append("CertificateAuthorityArn: ").append(this.getCertificateAuthorityArn()).append(",");
        }
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getSourceAccount() != null) {
            sb.append("SourceAccount: ").append(this.getSourceAccount()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePermissionRequest)) {
            return false;
        }
        CreatePermissionRequest other = (CreatePermissionRequest)obj;
        if (other.getCertificateAuthorityArn() == null ^ this.getCertificateAuthorityArn() == null) {
            return false;
        }
        if (other.getCertificateAuthorityArn() != null && !other.getCertificateAuthorityArn().equals(this.getCertificateAuthorityArn())) {
            return false;
        }
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getSourceAccount() == null ^ this.getSourceAccount() == null) {
            return false;
        }
        if (other.getSourceAccount() != null && !other.getSourceAccount().equals(this.getSourceAccount())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        return other.getActions() == null || other.getActions().equals(this.getActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateAuthorityArn() == null ? 0 : this.getCertificateAuthorityArn().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getSourceAccount() == null ? 0 : this.getSourceAccount().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        return hashCode;
    }

    public CreatePermissionRequest clone() {
        return (CreatePermissionRequest)super.clone();
    }
}

