/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.acmpca.AWSACMPCAAsync;
import com.amazonaws.services.acmpca.AWSACMPCAAsyncClientBuilder;
import com.amazonaws.services.acmpca.AWSACMPCAClient;
import com.amazonaws.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest;
import com.amazonaws.services.acmpca.model.CreateCertificateAuthorityAuditReportResult;
import com.amazonaws.services.acmpca.model.CreateCertificateAuthorityRequest;
import com.amazonaws.services.acmpca.model.CreateCertificateAuthorityResult;
import com.amazonaws.services.acmpca.model.CreatePermissionRequest;
import com.amazonaws.services.acmpca.model.CreatePermissionResult;
import com.amazonaws.services.acmpca.model.DeleteCertificateAuthorityRequest;
import com.amazonaws.services.acmpca.model.DeleteCertificateAuthorityResult;
import com.amazonaws.services.acmpca.model.DeletePermissionRequest;
import com.amazonaws.services.acmpca.model.DeletePermissionResult;
import com.amazonaws.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest;
import com.amazonaws.services.acmpca.model.DescribeCertificateAuthorityAuditReportResult;
import com.amazonaws.services.acmpca.model.DescribeCertificateAuthorityRequest;
import com.amazonaws.services.acmpca.model.DescribeCertificateAuthorityResult;
import com.amazonaws.services.acmpca.model.GetCertificateAuthorityCertificateRequest;
import com.amazonaws.services.acmpca.model.GetCertificateAuthorityCertificateResult;
import com.amazonaws.services.acmpca.model.GetCertificateAuthorityCsrRequest;
import com.amazonaws.services.acmpca.model.GetCertificateAuthorityCsrResult;
import com.amazonaws.services.acmpca.model.GetCertificateRequest;
import com.amazonaws.services.acmpca.model.GetCertificateResult;
import com.amazonaws.services.acmpca.model.ImportCertificateAuthorityCertificateRequest;
import com.amazonaws.services.acmpca.model.ImportCertificateAuthorityCertificateResult;
import com.amazonaws.services.acmpca.model.IssueCertificateRequest;
import com.amazonaws.services.acmpca.model.IssueCertificateResult;
import com.amazonaws.services.acmpca.model.ListCertificateAuthoritiesRequest;
import com.amazonaws.services.acmpca.model.ListCertificateAuthoritiesResult;
import com.amazonaws.services.acmpca.model.ListPermissionsRequest;
import com.amazonaws.services.acmpca.model.ListPermissionsResult;
import com.amazonaws.services.acmpca.model.ListTagsRequest;
import com.amazonaws.services.acmpca.model.ListTagsResult;
import com.amazonaws.services.acmpca.model.RestoreCertificateAuthorityRequest;
import com.amazonaws.services.acmpca.model.RestoreCertificateAuthorityResult;
import com.amazonaws.services.acmpca.model.RevokeCertificateRequest;
import com.amazonaws.services.acmpca.model.RevokeCertificateResult;
import com.amazonaws.services.acmpca.model.TagCertificateAuthorityRequest;
import com.amazonaws.services.acmpca.model.TagCertificateAuthorityResult;
import com.amazonaws.services.acmpca.model.UntagCertificateAuthorityRequest;
import com.amazonaws.services.acmpca.model.UntagCertificateAuthorityResult;
import com.amazonaws.services.acmpca.model.UpdateCertificateAuthorityRequest;
import com.amazonaws.services.acmpca.model.UpdateCertificateAuthorityResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSACMPCAAsyncClient
extends AWSACMPCAClient
implements AWSACMPCAAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSACMPCAAsyncClientBuilder asyncBuilder() {
        return AWSACMPCAAsyncClientBuilder.standard();
    }

    AWSACMPCAAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateCertificateAuthorityResult> createCertificateAuthorityAsync(CreateCertificateAuthorityRequest request) {
        return this.createCertificateAuthorityAsync(request, null);
    }

    @Override
    public Future<CreateCertificateAuthorityResult> createCertificateAuthorityAsync(CreateCertificateAuthorityRequest request, final AsyncHandler<CreateCertificateAuthorityRequest, CreateCertificateAuthorityResult> asyncHandler) {
        final CreateCertificateAuthorityRequest finalRequest = (CreateCertificateAuthorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCertificateAuthorityResult>(){

            @Override
            public CreateCertificateAuthorityResult call() throws Exception {
                CreateCertificateAuthorityResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeCreateCertificateAuthority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCertificateAuthorityAuditReportResult> createCertificateAuthorityAuditReportAsync(CreateCertificateAuthorityAuditReportRequest request) {
        return this.createCertificateAuthorityAuditReportAsync(request, null);
    }

    @Override
    public Future<CreateCertificateAuthorityAuditReportResult> createCertificateAuthorityAuditReportAsync(CreateCertificateAuthorityAuditReportRequest request, final AsyncHandler<CreateCertificateAuthorityAuditReportRequest, CreateCertificateAuthorityAuditReportResult> asyncHandler) {
        final CreateCertificateAuthorityAuditReportRequest finalRequest = (CreateCertificateAuthorityAuditReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCertificateAuthorityAuditReportResult>(){

            @Override
            public CreateCertificateAuthorityAuditReportResult call() throws Exception {
                CreateCertificateAuthorityAuditReportResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeCreateCertificateAuthorityAuditReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePermissionResult> createPermissionAsync(CreatePermissionRequest request) {
        return this.createPermissionAsync(request, null);
    }

    @Override
    public Future<CreatePermissionResult> createPermissionAsync(CreatePermissionRequest request, final AsyncHandler<CreatePermissionRequest, CreatePermissionResult> asyncHandler) {
        final CreatePermissionRequest finalRequest = (CreatePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePermissionResult>(){

            @Override
            public CreatePermissionResult call() throws Exception {
                CreatePermissionResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeCreatePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCertificateAuthorityResult> deleteCertificateAuthorityAsync(DeleteCertificateAuthorityRequest request) {
        return this.deleteCertificateAuthorityAsync(request, null);
    }

    @Override
    public Future<DeleteCertificateAuthorityResult> deleteCertificateAuthorityAsync(DeleteCertificateAuthorityRequest request, final AsyncHandler<DeleteCertificateAuthorityRequest, DeleteCertificateAuthorityResult> asyncHandler) {
        final DeleteCertificateAuthorityRequest finalRequest = (DeleteCertificateAuthorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCertificateAuthorityResult>(){

            @Override
            public DeleteCertificateAuthorityResult call() throws Exception {
                DeleteCertificateAuthorityResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeDeleteCertificateAuthority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePermissionResult> deletePermissionAsync(DeletePermissionRequest request) {
        return this.deletePermissionAsync(request, null);
    }

    @Override
    public Future<DeletePermissionResult> deletePermissionAsync(DeletePermissionRequest request, final AsyncHandler<DeletePermissionRequest, DeletePermissionResult> asyncHandler) {
        final DeletePermissionRequest finalRequest = (DeletePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePermissionResult>(){

            @Override
            public DeletePermissionResult call() throws Exception {
                DeletePermissionResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeDeletePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCertificateAuthorityResult> describeCertificateAuthorityAsync(DescribeCertificateAuthorityRequest request) {
        return this.describeCertificateAuthorityAsync(request, null);
    }

    @Override
    public Future<DescribeCertificateAuthorityResult> describeCertificateAuthorityAsync(DescribeCertificateAuthorityRequest request, final AsyncHandler<DescribeCertificateAuthorityRequest, DescribeCertificateAuthorityResult> asyncHandler) {
        final DescribeCertificateAuthorityRequest finalRequest = (DescribeCertificateAuthorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCertificateAuthorityResult>(){

            @Override
            public DescribeCertificateAuthorityResult call() throws Exception {
                DescribeCertificateAuthorityResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeDescribeCertificateAuthority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCertificateAuthorityAuditReportResult> describeCertificateAuthorityAuditReportAsync(DescribeCertificateAuthorityAuditReportRequest request) {
        return this.describeCertificateAuthorityAuditReportAsync(request, null);
    }

    @Override
    public Future<DescribeCertificateAuthorityAuditReportResult> describeCertificateAuthorityAuditReportAsync(DescribeCertificateAuthorityAuditReportRequest request, final AsyncHandler<DescribeCertificateAuthorityAuditReportRequest, DescribeCertificateAuthorityAuditReportResult> asyncHandler) {
        final DescribeCertificateAuthorityAuditReportRequest finalRequest = (DescribeCertificateAuthorityAuditReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCertificateAuthorityAuditReportResult>(){

            @Override
            public DescribeCertificateAuthorityAuditReportResult call() throws Exception {
                DescribeCertificateAuthorityAuditReportResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeDescribeCertificateAuthorityAuditReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCertificateResult> getCertificateAsync(GetCertificateRequest request) {
        return this.getCertificateAsync(request, null);
    }

    @Override
    public Future<GetCertificateResult> getCertificateAsync(GetCertificateRequest request, final AsyncHandler<GetCertificateRequest, GetCertificateResult> asyncHandler) {
        final GetCertificateRequest finalRequest = (GetCertificateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCertificateResult>(){

            @Override
            public GetCertificateResult call() throws Exception {
                GetCertificateResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeGetCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCertificateAuthorityCertificateResult> getCertificateAuthorityCertificateAsync(GetCertificateAuthorityCertificateRequest request) {
        return this.getCertificateAuthorityCertificateAsync(request, null);
    }

    @Override
    public Future<GetCertificateAuthorityCertificateResult> getCertificateAuthorityCertificateAsync(GetCertificateAuthorityCertificateRequest request, final AsyncHandler<GetCertificateAuthorityCertificateRequest, GetCertificateAuthorityCertificateResult> asyncHandler) {
        final GetCertificateAuthorityCertificateRequest finalRequest = (GetCertificateAuthorityCertificateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCertificateAuthorityCertificateResult>(){

            @Override
            public GetCertificateAuthorityCertificateResult call() throws Exception {
                GetCertificateAuthorityCertificateResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeGetCertificateAuthorityCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCertificateAuthorityCsrResult> getCertificateAuthorityCsrAsync(GetCertificateAuthorityCsrRequest request) {
        return this.getCertificateAuthorityCsrAsync(request, null);
    }

    @Override
    public Future<GetCertificateAuthorityCsrResult> getCertificateAuthorityCsrAsync(GetCertificateAuthorityCsrRequest request, final AsyncHandler<GetCertificateAuthorityCsrRequest, GetCertificateAuthorityCsrResult> asyncHandler) {
        final GetCertificateAuthorityCsrRequest finalRequest = (GetCertificateAuthorityCsrRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCertificateAuthorityCsrResult>(){

            @Override
            public GetCertificateAuthorityCsrResult call() throws Exception {
                GetCertificateAuthorityCsrResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeGetCertificateAuthorityCsr(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportCertificateAuthorityCertificateResult> importCertificateAuthorityCertificateAsync(ImportCertificateAuthorityCertificateRequest request) {
        return this.importCertificateAuthorityCertificateAsync(request, null);
    }

    @Override
    public Future<ImportCertificateAuthorityCertificateResult> importCertificateAuthorityCertificateAsync(ImportCertificateAuthorityCertificateRequest request, final AsyncHandler<ImportCertificateAuthorityCertificateRequest, ImportCertificateAuthorityCertificateResult> asyncHandler) {
        final ImportCertificateAuthorityCertificateRequest finalRequest = (ImportCertificateAuthorityCertificateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportCertificateAuthorityCertificateResult>(){

            @Override
            public ImportCertificateAuthorityCertificateResult call() throws Exception {
                ImportCertificateAuthorityCertificateResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeImportCertificateAuthorityCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<IssueCertificateResult> issueCertificateAsync(IssueCertificateRequest request) {
        return this.issueCertificateAsync(request, null);
    }

    @Override
    public Future<IssueCertificateResult> issueCertificateAsync(IssueCertificateRequest request, final AsyncHandler<IssueCertificateRequest, IssueCertificateResult> asyncHandler) {
        final IssueCertificateRequest finalRequest = (IssueCertificateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<IssueCertificateResult>(){

            @Override
            public IssueCertificateResult call() throws Exception {
                IssueCertificateResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeIssueCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCertificateAuthoritiesResult> listCertificateAuthoritiesAsync(ListCertificateAuthoritiesRequest request) {
        return this.listCertificateAuthoritiesAsync(request, null);
    }

    @Override
    public Future<ListCertificateAuthoritiesResult> listCertificateAuthoritiesAsync(ListCertificateAuthoritiesRequest request, final AsyncHandler<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResult> asyncHandler) {
        final ListCertificateAuthoritiesRequest finalRequest = (ListCertificateAuthoritiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCertificateAuthoritiesResult>(){

            @Override
            public ListCertificateAuthoritiesResult call() throws Exception {
                ListCertificateAuthoritiesResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeListCertificateAuthorities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request) {
        return this.listPermissionsAsync(request, null);
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request, final AsyncHandler<ListPermissionsRequest, ListPermissionsResult> asyncHandler) {
        final ListPermissionsRequest finalRequest = (ListPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPermissionsResult>(){

            @Override
            public ListPermissionsResult call() throws Exception {
                ListPermissionsResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeListPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request) {
        return this.listTagsAsync(request, null);
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request, final AsyncHandler<ListTagsRequest, ListTagsResult> asyncHandler) {
        final ListTagsRequest finalRequest = (ListTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsResult>(){

            @Override
            public ListTagsResult call() throws Exception {
                ListTagsResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeListTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreCertificateAuthorityResult> restoreCertificateAuthorityAsync(RestoreCertificateAuthorityRequest request) {
        return this.restoreCertificateAuthorityAsync(request, null);
    }

    @Override
    public Future<RestoreCertificateAuthorityResult> restoreCertificateAuthorityAsync(RestoreCertificateAuthorityRequest request, final AsyncHandler<RestoreCertificateAuthorityRequest, RestoreCertificateAuthorityResult> asyncHandler) {
        final RestoreCertificateAuthorityRequest finalRequest = (RestoreCertificateAuthorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestoreCertificateAuthorityResult>(){

            @Override
            public RestoreCertificateAuthorityResult call() throws Exception {
                RestoreCertificateAuthorityResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeRestoreCertificateAuthority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RevokeCertificateResult> revokeCertificateAsync(RevokeCertificateRequest request) {
        return this.revokeCertificateAsync(request, null);
    }

    @Override
    public Future<RevokeCertificateResult> revokeCertificateAsync(RevokeCertificateRequest request, final AsyncHandler<RevokeCertificateRequest, RevokeCertificateResult> asyncHandler) {
        final RevokeCertificateRequest finalRequest = (RevokeCertificateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RevokeCertificateResult>(){

            @Override
            public RevokeCertificateResult call() throws Exception {
                RevokeCertificateResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeRevokeCertificate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagCertificateAuthorityResult> tagCertificateAuthorityAsync(TagCertificateAuthorityRequest request) {
        return this.tagCertificateAuthorityAsync(request, null);
    }

    @Override
    public Future<TagCertificateAuthorityResult> tagCertificateAuthorityAsync(TagCertificateAuthorityRequest request, final AsyncHandler<TagCertificateAuthorityRequest, TagCertificateAuthorityResult> asyncHandler) {
        final TagCertificateAuthorityRequest finalRequest = (TagCertificateAuthorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagCertificateAuthorityResult>(){

            @Override
            public TagCertificateAuthorityResult call() throws Exception {
                TagCertificateAuthorityResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeTagCertificateAuthority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagCertificateAuthorityResult> untagCertificateAuthorityAsync(UntagCertificateAuthorityRequest request) {
        return this.untagCertificateAuthorityAsync(request, null);
    }

    @Override
    public Future<UntagCertificateAuthorityResult> untagCertificateAuthorityAsync(UntagCertificateAuthorityRequest request, final AsyncHandler<UntagCertificateAuthorityRequest, UntagCertificateAuthorityResult> asyncHandler) {
        final UntagCertificateAuthorityRequest finalRequest = (UntagCertificateAuthorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagCertificateAuthorityResult>(){

            @Override
            public UntagCertificateAuthorityResult call() throws Exception {
                UntagCertificateAuthorityResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeUntagCertificateAuthority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateCertificateAuthorityResult> updateCertificateAuthorityAsync(UpdateCertificateAuthorityRequest request) {
        return this.updateCertificateAuthorityAsync(request, null);
    }

    @Override
    public Future<UpdateCertificateAuthorityResult> updateCertificateAuthorityAsync(UpdateCertificateAuthorityRequest request, final AsyncHandler<UpdateCertificateAuthorityRequest, UpdateCertificateAuthorityResult> asyncHandler) {
        final UpdateCertificateAuthorityRequest finalRequest = (UpdateCertificateAuthorityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateCertificateAuthorityResult>(){

            @Override
            public UpdateCertificateAuthorityResult call() throws Exception {
                UpdateCertificateAuthorityResult result = null;
                try {
                    result = AWSACMPCAAsyncClient.this.executeUpdateCertificateAuthority(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

