/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.certificatemanager.model.ResendValidationEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ResendValidationEmailRequestMarshaller
implements Marshaller<Request<ResendValidationEmailRequest>, ResendValidationEmailRequest> {
    public Request<ResendValidationEmailRequest> marshall(ResendValidationEmailRequest resendValidationEmailRequest) {
        if (resendValidationEmailRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resendValidationEmailRequest, "AWSCertificateManager");
        request.addHeader("X-Amz-Target", "CertificateManager.ResendValidationEmail");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (resendValidationEmailRequest.getCertificateArn() != null) {
                jsonGenerator.writeFieldName("CertificateArn").writeValue(resendValidationEmailRequest.getCertificateArn());
            }
            if (resendValidationEmailRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("Domain").writeValue(resendValidationEmailRequest.getDomain());
            }
            if (resendValidationEmailRequest.getValidationDomain() != null) {
                jsonGenerator.writeFieldName("ValidationDomain").writeValue(resendValidationEmailRequest.getValidationDomain());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

